/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.ScalarOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseScalarBoolOp
extends BaseOp
implements ScalarOp {
    private static final Logger log = LoggerFactory.getLogger(BaseScalarBoolOp.class);

    public BaseScalarBoolOp() {
    }

    public BaseScalarBoolOp(INDArray x, INDArray y, INDArray z, Number num) {
        super(x, y, z);
        this.scalarValue = Nd4j.scalar(x.dataType(), num);
    }

    public BaseScalarBoolOp(INDArray x, Number num) {
        super(x);
        this.scalarValue = Nd4j.scalar(x.dataType(), num);
    }

    public BaseScalarBoolOp(INDArray x, INDArray z, Number set) {
        super(x, null, z);
        this.scalarValue = Nd4j.scalar(x.dataType(), set);
    }

    public BaseScalarBoolOp(SameDiff sameDiff, SDVariable i_v, Number scalar) {
        this(sameDiff, i_v, scalar, false, null);
    }

    public BaseScalarBoolOp(SameDiff sameDiff, SDVariable i_v, Number scalar, boolean inPlace) {
        this(sameDiff, i_v, scalar, inPlace, null);
    }

    public BaseScalarBoolOp(SameDiff sameDiff, SDVariable i_v, Number scalar, boolean inPlace, Object[] extraArgs) {
        super(sameDiff, inPlace, extraArgs);
        this.scalarValue = Nd4j.scalar(i_v.dataType(), scalar);
        if (i_v == null) {
            throw new IllegalArgumentException("Input not null variable.");
        }
        this.xVertexId = i_v.name();
        sameDiff.addArgsFor(new String[]{this.xVertexId}, (DifferentialFunction)this);
        this.f().validateDifferentialFunctionsameDiff(i_v);
    }

    public BaseScalarBoolOp(SameDiff sameDiff, SDVariable i_v, Number scalar, Object[] extraArgs) {
        this(sameDiff, i_v, scalar, false, extraArgs);
    }

    @Override
    public INDArray z() {
        return this.z;
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        if (this.x == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(LongShapeDescriptor.fromShape(this.x.shape(), DataType.BOOL));
    }

    @Override
    public Op.Type opType() {
        return Op.Type.SCALAR_BOOL;
    }

    @Override
    public void setScalar(Number scalar) {
        this.scalarValue = Nd4j.scalar(scalar);
    }

    @Override
    public void setScalar(INDArray scalar) {
        this.scalarValue = scalar;
    }

    @Override
    public INDArray scalar() {
        if (this.scalarValue == null && this.y() != null && this.y().isScalar()) {
            return this.y();
        }
        return this.scalarValue;
    }

    @Override
    public int[] getDimension() {
        return this.dimensions;
    }

    @Override
    public void setDimension(int ... dimension) {
        this.defineDimensions(dimension);
    }

    @Override
    public boolean validateDataTypes(boolean experimentalMode) {
        Preconditions.checkArgument((boolean)this.z().isB(), (String)("Op.Z must have floating point type, since one of operands is floating point. op.z.datatype=" + this.z().dataType()));
        return true;
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.SCALAR_BOOL;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input datatype for %s, got input %s", this.getClass(), dataTypes);
        return Collections.singletonList(DataType.BOOL);
    }
}

