/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.List;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.util.LinAlgExceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTransformOp
extends BaseOp
implements TransformOp {
    private static final Logger log = LoggerFactory.getLogger(BaseTransformOp.class);

    public BaseTransformOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2) {
        this(sameDiff, i_v1, i_v2, false);
    }

    public BaseTransformOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, boolean inPlace) {
        super(sameDiff, inPlace, new Object[]{i_v2});
        if (i_v1 == null || i_v2 == null) {
            throw new IllegalArgumentException("Input not null variables.");
        }
        this.f().validateDifferentialFunctionsameDiff(i_v1);
        this.f().validateDifferentialFunctionsameDiff(i_v2);
        this.sameDiff = sameDiff;
        this.inPlace = inPlace;
        this.xVertexId = i_v1.name();
        this.yVertexId = i_v2.name();
        sameDiff.addArgsFor(new SDVariable[]{i_v1, i_v2}, (DifferentialFunction)this);
    }

    public BaseTransformOp(SameDiff sameDiff) {
        this.sameDiff = sameDiff;
    }

    public BaseTransformOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, Object[] extraArgs) {
        super(sameDiff, extraArgs);
        if (i_v1 == null || i_v2 == null) {
            throw new IllegalArgumentException("Input not null variables.");
        }
        this.f().validateDifferentialFunctionsameDiff(i_v1);
        this.f().validateDifferentialFunctionsameDiff(i_v2);
        this.sameDiff = sameDiff;
        this.xVertexId = i_v1.name();
        this.yVertexId = i_v2.name();
        sameDiff.addArgsFor(new SDVariable[]{i_v1, i_v2}, (DifferentialFunction)this);
    }

    public BaseTransformOp(SameDiff sameDiff, SDVariable i_v, boolean inPlace) {
        this(sameDiff, i_v, i_v.getShape(), inPlace, null);
    }

    public BaseTransformOp(SameDiff sameDiff, SDVariable i_v, long[] shape, boolean inPlace, Object[] extraArgs) {
        super(sameDiff, inPlace, extraArgs);
        if (i_v == null) {
            throw new IllegalArgumentException("Input must not null variable.");
        }
        this.f().validateDifferentialFunctionsameDiff(i_v);
        this.xVertexId = i_v.name();
        sameDiff.addArgsFor(new SDVariable[]{i_v}, (DifferentialFunction)this);
    }

    public BaseTransformOp(SameDiff sameDiff, SDVariable i_v, Object[] extraArgs) {
        this(sameDiff, i_v, i_v.getShape(), false, extraArgs);
    }

    public BaseTransformOp(INDArray x, INDArray z) {
        super(x, z);
        LinAlgExceptions.assertSameShape(x, z);
    }

    public BaseTransformOp() {
    }

    public BaseTransformOp(INDArray x, INDArray y, INDArray z) {
        super(x, y, z);
        if (y != null) {
            LinAlgExceptions.assertSameLength(x, y, z);
        } else if (z != null) {
            LinAlgExceptions.assertSameLength(x, z);
        }
    }

    public BaseTransformOp(INDArray x) {
        super(x);
    }

    @Override
    public abstract List<LongShapeDescriptor> calculateOutputShape();

    @Override
    public INDArray z() {
        return this.z;
    }
}

