/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.custom;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class FakeQuantWithMinMaxVarsPerChannel
extends DynamicCustomOp {
    protected boolean narrowRange;
    protected int numBits;

    public FakeQuantWithMinMaxVarsPerChannel() {
    }

    public FakeQuantWithMinMaxVarsPerChannel(INDArray x, INDArray min, INDArray max, int num_bits, boolean narrow) {
        Preconditions.checkArgument((min.isVector() && max.isVector() && min.length() == max.length() ? 1 : 0) != 0, (String)"FakeQuantWithMinMaxVarsPerChannel: min and max should be 1D tensors with the same length");
        this.addInputArgument(x, min, max);
        this.addIArgument(num_bits);
        this.addBArgument(narrow);
    }

    public FakeQuantWithMinMaxVarsPerChannel(INDArray x, INDArray min, INDArray max, int num_bits) {
        this(x, min, max, num_bits, false);
    }

    public FakeQuantWithMinMaxVarsPerChannel(INDArray x, INDArray min, INDArray max, boolean narrow) {
        this(x, min, max, 8, narrow);
    }

    public FakeQuantWithMinMaxVarsPerChannel(INDArray x, INDArray min, INDArray max) {
        this(x, min, max, 8, false);
    }

    public FakeQuantWithMinMaxVarsPerChannel(SameDiff sameDiff, SDVariable x, SDVariable min, SDVariable max, int num_bits, boolean narrow) {
        super("", sameDiff, new SDVariable[]{x, min, max});
        this.addIArgument(num_bits);
        this.addBArgument(narrow);
    }

    @Override
    public String opName() {
        return "fake_quant_with_min_max_vars_per_channel";
    }

    @Override
    public String tensorflowName() {
        return "FakeQuantWithMinMaxVarsPerChannel";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        if (attributesForNode.containsKey("narrow_range")) {
            this.narrowRange = attributesForNode.get("narrow_range").getB();
        }
        if (attributesForNode.containsKey("num_bits")) {
            this.numBits = (int)attributesForNode.get("num_bits").getI();
        }
        this.addIArgument(this.numBits);
        this.addBArgument(this.narrowRange);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == 3 ? 1 : 0) != 0, (String)"Expected exactly 3 inputs, got %s", inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }
}

