/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.custom;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class RandomCrop
extends DynamicCustomOp {
    public RandomCrop() {
    }

    public RandomCrop(@NonNull INDArray input, @NonNull INDArray shape) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked @NonNull but is null");
        }
        Preconditions.checkArgument((boolean)shape.isVector(), (String)"RandomCrop:Shape tensor should be a vector");
        Preconditions.checkArgument(((long)input.rank() == shape.length() ? 1 : 0) != 0, (String)"RandomCrop:The length of the shape vector is not match input rank");
        this.addInputArgument(input, shape);
    }

    public RandomCrop(@NonNull SameDiff sameDiff, @NonNull SDVariable input, @NonNull SDVariable shape) {
        super("", sameDiff, new SDVariable[]{input, shape});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked @NonNull but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked @NonNull but is null");
        }
    }

    @Override
    public String opName() {
        return "random_crop";
    }

    @Override
    public String tensorflowName() {
        return "RandomCrop";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null ? 1 : 0) != 0, (String)"Expected 4 input datatypes for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(DataType.FLOAT);
    }
}

