/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.recurrent.weights;

import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.weights.RNNWeights;

public class LSTMWeights
extends RNNWeights {
    @NonNull
    private SDVariable weights;
    @NonNull
    private SDVariable inputPeepholeWeights;
    @NonNull
    private SDVariable forgetPeepholeWeights;
    @NonNull
    private SDVariable outputPeepholeWeights;
    @NonNull
    private SDVariable bias;

    @Override
    public SDVariable[] args() {
        return LSTMWeights.filterNonNull(this.weights, this.inputPeepholeWeights, this.forgetPeepholeWeights, this.outputPeepholeWeights, this.bias);
    }

    LSTMWeights(@NonNull SDVariable weights, @NonNull SDVariable inputPeepholeWeights, @NonNull SDVariable forgetPeepholeWeights, @NonNull SDVariable outputPeepholeWeights, @NonNull SDVariable bias) {
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (inputPeepholeWeights == null) {
            throw new NullPointerException("inputPeepholeWeights is marked @NonNull but is null");
        }
        if (forgetPeepholeWeights == null) {
            throw new NullPointerException("forgetPeepholeWeights is marked @NonNull but is null");
        }
        if (outputPeepholeWeights == null) {
            throw new NullPointerException("outputPeepholeWeights is marked @NonNull but is null");
        }
        if (bias == null) {
            throw new NullPointerException("bias is marked @NonNull but is null");
        }
        this.weights = weights;
        this.inputPeepholeWeights = inputPeepholeWeights;
        this.forgetPeepholeWeights = forgetPeepholeWeights;
        this.outputPeepholeWeights = outputPeepholeWeights;
        this.bias = bias;
    }

    public static LSTMWeightsBuilder builder() {
        return new LSTMWeightsBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LSTMWeights)) {
            return false;
        }
        LSTMWeights other = (LSTMWeights)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SDVariable this$weights = this.getWeights();
        SDVariable other$weights = other.getWeights();
        if (this$weights == null ? other$weights != null : !((Object)this$weights).equals(other$weights)) {
            return false;
        }
        SDVariable this$inputPeepholeWeights = this.getInputPeepholeWeights();
        SDVariable other$inputPeepholeWeights = other.getInputPeepholeWeights();
        if (this$inputPeepholeWeights == null ? other$inputPeepholeWeights != null : !((Object)this$inputPeepholeWeights).equals(other$inputPeepholeWeights)) {
            return false;
        }
        SDVariable this$forgetPeepholeWeights = this.getForgetPeepholeWeights();
        SDVariable other$forgetPeepholeWeights = other.getForgetPeepholeWeights();
        if (this$forgetPeepholeWeights == null ? other$forgetPeepholeWeights != null : !((Object)this$forgetPeepholeWeights).equals(other$forgetPeepholeWeights)) {
            return false;
        }
        SDVariable this$outputPeepholeWeights = this.getOutputPeepholeWeights();
        SDVariable other$outputPeepholeWeights = other.getOutputPeepholeWeights();
        if (this$outputPeepholeWeights == null ? other$outputPeepholeWeights != null : !((Object)this$outputPeepholeWeights).equals(other$outputPeepholeWeights)) {
            return false;
        }
        SDVariable this$bias = this.getBias();
        SDVariable other$bias = other.getBias();
        return !(this$bias == null ? other$bias != null : !((Object)this$bias).equals(other$bias));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LSTMWeights;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SDVariable $weights = this.getWeights();
        result = result * 59 + ($weights == null ? 43 : ((Object)$weights).hashCode());
        SDVariable $inputPeepholeWeights = this.getInputPeepholeWeights();
        result = result * 59 + ($inputPeepholeWeights == null ? 43 : ((Object)$inputPeepholeWeights).hashCode());
        SDVariable $forgetPeepholeWeights = this.getForgetPeepholeWeights();
        result = result * 59 + ($forgetPeepholeWeights == null ? 43 : ((Object)$forgetPeepholeWeights).hashCode());
        SDVariable $outputPeepholeWeights = this.getOutputPeepholeWeights();
        result = result * 59 + ($outputPeepholeWeights == null ? 43 : ((Object)$outputPeepholeWeights).hashCode());
        SDVariable $bias = this.getBias();
        result = result * 59 + ($bias == null ? 43 : ((Object)$bias).hashCode());
        return result;
    }

    @NonNull
    public SDVariable getWeights() {
        return this.weights;
    }

    @NonNull
    public SDVariable getInputPeepholeWeights() {
        return this.inputPeepholeWeights;
    }

    @NonNull
    public SDVariable getForgetPeepholeWeights() {
        return this.forgetPeepholeWeights;
    }

    @NonNull
    public SDVariable getOutputPeepholeWeights() {
        return this.outputPeepholeWeights;
    }

    @NonNull
    public SDVariable getBias() {
        return this.bias;
    }

    public void setWeights(@NonNull SDVariable weights) {
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        this.weights = weights;
    }

    public void setInputPeepholeWeights(@NonNull SDVariable inputPeepholeWeights) {
        if (inputPeepholeWeights == null) {
            throw new NullPointerException("inputPeepholeWeights is marked @NonNull but is null");
        }
        this.inputPeepholeWeights = inputPeepholeWeights;
    }

    public void setForgetPeepholeWeights(@NonNull SDVariable forgetPeepholeWeights) {
        if (forgetPeepholeWeights == null) {
            throw new NullPointerException("forgetPeepholeWeights is marked @NonNull but is null");
        }
        this.forgetPeepholeWeights = forgetPeepholeWeights;
    }

    public void setOutputPeepholeWeights(@NonNull SDVariable outputPeepholeWeights) {
        if (outputPeepholeWeights == null) {
            throw new NullPointerException("outputPeepholeWeights is marked @NonNull but is null");
        }
        this.outputPeepholeWeights = outputPeepholeWeights;
    }

    public void setBias(@NonNull SDVariable bias) {
        if (bias == null) {
            throw new NullPointerException("bias is marked @NonNull but is null");
        }
        this.bias = bias;
    }

    public String toString() {
        return "LSTMWeights(weights=" + this.getWeights() + ", inputPeepholeWeights=" + this.getInputPeepholeWeights() + ", forgetPeepholeWeights=" + this.getForgetPeepholeWeights() + ", outputPeepholeWeights=" + this.getOutputPeepholeWeights() + ", bias=" + this.getBias() + ")";
    }

    public static class LSTMWeightsBuilder {
        private SDVariable weights;
        private SDVariable inputPeepholeWeights;
        private SDVariable forgetPeepholeWeights;
        private SDVariable outputPeepholeWeights;
        private SDVariable bias;

        LSTMWeightsBuilder() {
        }

        public LSTMWeightsBuilder weights(SDVariable weights) {
            this.weights = weights;
            return this;
        }

        public LSTMWeightsBuilder inputPeepholeWeights(SDVariable inputPeepholeWeights) {
            this.inputPeepholeWeights = inputPeepholeWeights;
            return this;
        }

        public LSTMWeightsBuilder forgetPeepholeWeights(SDVariable forgetPeepholeWeights) {
            this.forgetPeepholeWeights = forgetPeepholeWeights;
            return this;
        }

        public LSTMWeightsBuilder outputPeepholeWeights(SDVariable outputPeepholeWeights) {
            this.outputPeepholeWeights = outputPeepholeWeights;
            return this;
        }

        public LSTMWeightsBuilder bias(SDVariable bias) {
            this.bias = bias;
            return this;
        }

        public LSTMWeights build() {
            return new LSTMWeights(this.weights, this.inputPeepholeWeights, this.forgetPeepholeWeights, this.outputPeepholeWeights, this.bias);
        }

        public String toString() {
            return "LSTMWeights.LSTMWeightsBuilder(weights=" + this.weights + ", inputPeepholeWeights=" + this.inputPeepholeWeights + ", forgetPeepholeWeights=" + this.forgetPeepholeWeights + ", outputPeepholeWeights=" + this.outputPeepholeWeights + ", bias=" + this.bias + ")";
        }
    }
}

