/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.bloomFilter;

import org.nlpcn.commons.lang.bloomFilter.filter.JSFilter;
import org.nlpcn.commons.lang.bloomFilter.filter.JavaFilter;
import org.nlpcn.commons.lang.bloomFilter.filter.PHPFilter;
import org.nlpcn.commons.lang.bloomFilter.filter.PJWFilter;
import org.nlpcn.commons.lang.bloomFilter.filter.SDBMFilter;
import org.nlpcn.commons.lang.bloomFilter.iface.Filter;

public class BloomFilter {
    private static int length = 5;
    Filter[] filters = new Filter[length];

    public BloomFilter(int m) throws Exception {
        float mNum = m / 5;
        long size = (long)(1.0f * mNum * 1024.0f * 1024.0f * 8.0f);
        this.filters[0] = new JavaFilter(size);
        this.filters[1] = new PHPFilter(size);
        this.filters[2] = new JSFilter(size);
        this.filters[3] = new PJWFilter(size);
        this.filters[4] = new SDBMFilter(size);
    }

    public void add(String str) {
        for (int i = 0; i < length; ++i) {
            this.filters[i].add(str);
        }
    }

    public boolean contains(String str) {
        for (int i = 0; i < length; ++i) {
            if (this.filters[i].contains(str)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAndAdd(String str) {
        boolean flag = this.contains(str);
        if (!flag) {
            this.add(str);
        }
        return flag;
    }
}

