/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.util.logging;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.nlpcn.commons.lang.util.logging.Log;

public class Log4jImpl
implements Log {
    private static final String callerFQCN = Log4jImpl.class.getName();
    private Logger log;
    private int errorCount;
    private int warnCount;
    private int infoCount;
    private int debugCount;

    public Log4jImpl(Logger log) {
        this.log = log;
    }

    public Log4jImpl(String loggerName) {
        this.log = Logger.getLogger((String)loggerName);
    }

    public Logger getLog() {
        return this.log;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public void error(String s, Throwable e) {
        ++this.errorCount;
        this.log.log(callerFQCN, (Priority)Level.ERROR, (Object)s, e);
    }

    @Override
    public void error(String s) {
        ++this.errorCount;
        this.log.log(callerFQCN, (Priority)Level.ERROR, (Object)s, null);
    }

    @Override
    public void debug(String s) {
        ++this.debugCount;
        this.log.log(callerFQCN, (Priority)Level.DEBUG, (Object)s, null);
    }

    @Override
    public void debug(String s, Throwable e) {
        ++this.debugCount;
        this.log.log(callerFQCN, (Priority)Level.DEBUG, (Object)s, e);
    }

    @Override
    public void warn(String s) {
        this.log.log(callerFQCN, (Priority)Level.WARN, (Object)s, null);
        ++this.warnCount;
    }

    @Override
    public void warn(String s, Throwable e) {
        this.log.log(callerFQCN, (Priority)Level.WARN, (Object)s, e);
        ++this.warnCount;
    }

    public int getWarnCount() {
        return this.warnCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void resetStat() {
        this.errorCount = 0;
        this.warnCount = 0;
        this.infoCount = 0;
        this.debugCount = 0;
    }

    public int getDebugCount() {
        return this.debugCount;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        ++this.infoCount;
        this.log.log(callerFQCN, (Priority)Level.INFO, (Object)msg, null);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isEnabledFor((Priority)Level.WARN);
    }

    public int getInfoCount() {
        return this.infoCount;
    }

    public String toString() {
        return this.log.toString();
    }
}

