/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.format.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.tinygroup.context.Context;
import org.tinygroup.format.FormatProvider;
import org.tinygroup.format.Formater;
import org.tinygroup.format.PatternDefine;
import org.tinygroup.format.exception.FormatException;
import org.tinygroup.format.impl.DefaultPatternDefine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormaterImpl
implements Formater {
    private Map<String, FormatProvider> formatProviders;
    private PatternDefine patternDefine = new DefaultPatternDefine();

    @Override
    public String format(Context context, String source) throws FormatException {
        Matcher matcher = this.patternDefine.getPattern().matcher(source);
        StringBuffer buf = new StringBuffer();
        int curpos = 0;
        while (matcher.find()) {
            String replaceStr = this.patternDefine.getPureMatchText(matcher.group());
            buf.append(source.substring(curpos, matcher.start()));
            curpos = matcher.end();
            String str = this.formatSingle(context, replaceStr);
            if (str == null) continue;
            buf.append(str);
        }
        buf.append(source.substring(curpos));
        return buf.toString();
    }

    private String formatSingle(Context context, String string) throws FormatException {
        String[] s = string.split(this.patternDefine.getSplitChar() + "");
        if (s.length >= 2) {
            FormatProvider o = this.formatProviders.get(s[0]);
            if (o != null) {
                return o.format(context, s[1]);
            }
        } else {
            FormatProvider o = this.formatProviders.get("");
            if (o != null) {
                return o.format(context, string);
            }
        }
        return this.patternDefine.getFullMatchText(string);
    }

    @Override
    public void setFormatProviders(Map<String, FormatProvider> formatProviders) {
        this.formatProviders = formatProviders;
    }

    @Override
    public void setPatternHandle(PatternDefine patternHandle) {
        this.patternDefine = patternHandle;
    }

    @Override
    public void addFormatProvider(String prefix, FormatProvider formatProvider) {
        if (this.formatProviders == null) {
            this.formatProviders = new HashMap<String, FormatProvider>();
        }
        this.formatProviders.put(prefix, formatProvider);
    }
}

