/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.os;

import com.alipay.lookout.spi.MetricsImporter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public abstract class CachedMetricsImporter
implements MetricsImporter {
    private static int MAX_RETRY_TIME = 3;
    protected static long DEFAULT_TIMEOUT_MS = 5000L;
    private final AtomicLong reloadAt = new AtomicLong(0L);
    private final long timeoutMS;

    public CachedMetricsImporter() {
        this.timeoutMS = DEFAULT_TIMEOUT_MS;
    }

    public CachedMetricsImporter(long timeout, TimeUnit timeoutUnit) {
        this.timeoutMS = timeoutUnit.toMillis(timeout);
    }

    protected void loadIfNessesary() {
        for (int retryTimes = 0; retryTimes < MAX_RETRY_TIME; ++retryTimes) {
            long time = System.currentTimeMillis();
            long current = this.reloadAt.get();
            if (current > time) {
                return;
            }
            if (!this.reloadAt.compareAndSet(current, time + this.timeoutMS)) continue;
            this.loadValues();
            return;
        }
    }

    protected abstract void loadValues();
}

