/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.os.linux;

import com.alipay.lookout.api.Gauge;
import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.Registry;
import com.alipay.lookout.api.composite.MixinMetric;
import com.alipay.lookout.common.log.LookoutLoggerFactory;
import com.alipay.lookout.os.CachedMetricsImporter;
import com.alipay.lookout.os.utils.FileUtils;
import com.alipay.lookout.os.utils.NumFormatUtils;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class CpuUsageMetricsImporter
extends CachedMetricsImporter {
    private final Logger logger = LookoutLoggerFactory.getLogger(CpuUsageMetricsImporter.class);
    private static final String DEFAULT_FILE_PATH = "/proc/stat";
    private static final Pattern cpuStatPattern = Pattern.compile("^.*cpu\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+).*$", 32);
    private static final int USER_INDEX = 1;
    private static final int NICE_INDEX = 2;
    private static final int SYSTEM_INDEX = 3;
    private static final int IDLE_INDEX = 4;
    private static final int IO_WAIT_INDEX = 5;
    private static final int IRQ_INDEX = 6;
    private static final int SOFT_IRQ_INDEX = 7;
    private static final int STOLEN_INDEX = 8;
    private static final int GUEST_INDEX = 9;
    private String filePath;
    private float[] cpuUsage;
    private CpuInfo lastCpuInfo;

    public CpuUsageMetricsImporter() {
        this(DEFAULT_FILE_PATH, DEFAULT_TIMEOUT_MS, TimeUnit.MILLISECONDS);
    }

    public CpuUsageMetricsImporter(String filePath, long timeout, TimeUnit timeoutUnit) {
        super(timeout, timeoutUnit);
        this.filePath = filePath;
        this.cpuUsage = new float[CpuUsage.values().length];
        this.lastCpuInfo = new CpuInfo();
    }

    public void register(Registry registry) {
        Id id = registry.createId("os.cpu");
        MixinMetric mixin = registry.mixinMetric(id);
        mixin.gauge("user", (Gauge)new Gauge<Float>(){

            public Float value() {
                CpuUsageMetricsImporter.this.loadIfNessesary();
                return Float.valueOf(CpuUsageMetricsImporter.this.cpuUsage[CpuUsage.USER.ordinal()]);
            }
        });
        mixin.gauge("nice", (Gauge)new Gauge<Float>(){

            public Float value() {
                CpuUsageMetricsImporter.this.loadIfNessesary();
                return Float.valueOf(CpuUsageMetricsImporter.this.cpuUsage[CpuUsage.NICE.ordinal()]);
            }
        });
        mixin.gauge("system", (Gauge)new Gauge<Float>(){

            public Float value() {
                CpuUsageMetricsImporter.this.loadIfNessesary();
                return Float.valueOf(CpuUsageMetricsImporter.this.cpuUsage[CpuUsage.SYSTEM.ordinal()]);
            }
        });
        mixin.gauge("idle", (Gauge)new Gauge<Float>(){

            public Float value() {
                CpuUsageMetricsImporter.this.loadIfNessesary();
                return Float.valueOf(CpuUsageMetricsImporter.this.cpuUsage[CpuUsage.IDLE.ordinal()]);
            }
        });
        mixin.gauge("iowait", (Gauge)new Gauge<Float>(){

            public Float value() {
                CpuUsageMetricsImporter.this.loadIfNessesary();
                return Float.valueOf(CpuUsageMetricsImporter.this.cpuUsage[CpuUsage.IOWAIT.ordinal()]);
            }
        });
        mixin.gauge("irq", (Gauge)new Gauge<Float>(){

            public Float value() {
                CpuUsageMetricsImporter.this.loadIfNessesary();
                return Float.valueOf(CpuUsageMetricsImporter.this.cpuUsage[CpuUsage.IRQ.ordinal()]);
            }
        });
        mixin.gauge("softirq", (Gauge)new Gauge<Float>(){

            public Float value() {
                CpuUsageMetricsImporter.this.loadIfNessesary();
                return Float.valueOf(CpuUsageMetricsImporter.this.cpuUsage[CpuUsage.SOFTIRQ.ordinal()]);
            }
        });
    }

    @Override
    protected void loadValues() {
        CpuInfo currentCpuInfo = this.collectCpuInfo();
        if (currentCpuInfo == null) {
            this.logger.info("warning,collect cpu info failed!");
            this.lastCpuInfo = new CpuInfo();
            return;
        }
        this.cpuUsage[CpuUsage.USER.ordinal()] = NumFormatUtils.formatFloat(100.0f * (float)(currentCpuInfo.userTime - this.lastCpuInfo.userTime) / (float)(currentCpuInfo.totalTime - this.lastCpuInfo.totalTime));
        this.cpuUsage[CpuUsage.NICE.ordinal()] = NumFormatUtils.formatFloat(100.0f * (float)(currentCpuInfo.niceTime - this.lastCpuInfo.niceTime) / (float)(currentCpuInfo.totalTime - this.lastCpuInfo.totalTime));
        this.cpuUsage[CpuUsage.SYSTEM.ordinal()] = NumFormatUtils.formatFloat(100.0f * (float)(currentCpuInfo.systemTime - this.lastCpuInfo.systemTime) / (float)(currentCpuInfo.totalTime - this.lastCpuInfo.totalTime));
        this.cpuUsage[CpuUsage.IDLE.ordinal()] = NumFormatUtils.formatFloat(100.0f * (float)(currentCpuInfo.idleTime - this.lastCpuInfo.idleTime) / (float)(currentCpuInfo.totalTime - this.lastCpuInfo.totalTime));
        this.cpuUsage[CpuUsage.IOWAIT.ordinal()] = NumFormatUtils.formatFloat(100.0f * (float)(currentCpuInfo.ioWaitTime - this.lastCpuInfo.ioWaitTime) / (float)(currentCpuInfo.totalTime - this.lastCpuInfo.totalTime));
        this.cpuUsage[CpuUsage.IRQ.ordinal()] = NumFormatUtils.formatFloat(100.0f * (float)(currentCpuInfo.irqTime - this.lastCpuInfo.irqTime) / (float)(currentCpuInfo.totalTime - this.lastCpuInfo.totalTime));
        this.cpuUsage[CpuUsage.SOFTIRQ.ordinal()] = NumFormatUtils.formatFloat(100.0f * (float)(currentCpuInfo.softIrqTime - this.lastCpuInfo.softIrqTime) / (float)(currentCpuInfo.totalTime - this.lastCpuInfo.totalTime));
        this.lastCpuInfo = currentCpuInfo;
    }

    private CpuInfo collectCpuInfo() {
        try {
            String statResult = FileUtils.readFile(this.filePath);
            Matcher statMatcher = cpuStatPattern.matcher(statResult);
            if (statMatcher.matches()) {
                CpuInfo cpuInfo = new CpuInfo();
                block13: for (int index = 1; index < statMatcher.groupCount(); ++index) {
                    long time = Long.parseLong(statMatcher.group(index));
                    cpuInfo.totalTime += time;
                    switch (index) {
                        case 1: {
                            cpuInfo.userTime = time;
                            continue block13;
                        }
                        case 2: {
                            cpuInfo.niceTime = time;
                            continue block13;
                        }
                        case 3: {
                            cpuInfo.systemTime = time;
                            continue block13;
                        }
                        case 4: {
                            cpuInfo.idleTime = time;
                            continue block13;
                        }
                        case 5: {
                            cpuInfo.ioWaitTime = time;
                            continue block13;
                        }
                        case 6: {
                            cpuInfo.irqTime = time;
                            continue block13;
                        }
                        case 7: {
                            cpuInfo.softIrqTime = time;
                            continue block13;
                        }
                        case 8: {
                            cpuInfo.stolenTime = time;
                            continue block13;
                        }
                        case 9: {
                            cpuInfo.guestTime = time;
                        }
                    }
                }
                return cpuInfo;
            }
        }
        catch (Exception e) {
            this.logger.info("waring,can't parse text at /proc/stat", (Object)e.getMessage());
        }
        return null;
    }

    private class CpuInfo {
        long totalTime;
        long userTime;
        long niceTime;
        long systemTime;
        long idleTime;
        long ioWaitTime;
        long irqTime;
        long softIrqTime;
        long stolenTime;
        long guestTime;

        private CpuInfo() {
        }
    }

    private static enum CpuUsage {
        USER,
        NICE,
        SYSTEM,
        IDLE,
        IOWAIT,
        IRQ,
        SOFTIRQ;

    }
}

