/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.os.linux;

import com.alipay.lookout.api.Gauge;
import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.Registry;
import com.alipay.lookout.api.composite.MixinMetric;
import com.alipay.lookout.common.log.LookoutLoggerFactory;
import com.alipay.lookout.os.CachedMetricsImporter;
import com.alipay.lookout.os.utils.FileUtils;
import com.alipay.lookout.os.utils.NumFormatUtils;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class DiskUsageMetricsImporter
extends CachedMetricsImporter {
    private final Logger logger = LookoutLoggerFactory.getLogger(DiskUsageMetricsImporter.class);
    private static final int TOTAL_LENGTH = 6;
    private static final String DEFAULT_FILE_PATH = "/proc/mounts";
    private static final String SPLIT = "\\s+";
    private static final List<String> IGNORE_FS_TYPES = Arrays.asList("cgroup", "debugfs", "devtmpfs", "nfs", "rpc_pipefs", "rootfs");
    private String filePath;
    private Map<String, DiskUsage> diskUsageByDevice;

    public DiskUsageMetricsImporter() {
        this(DEFAULT_FILE_PATH, DEFAULT_TIMEOUT_MS, TimeUnit.MILLISECONDS);
    }

    public DiskUsageMetricsImporter(String filePath, long timeout, TimeUnit timeoutUnit) {
        super(timeout, timeoutUnit);
        this.filePath = filePath;
        this.diskUsageByDevice = new HashMap<String, DiskUsage>();
        this.loadIfNessesary();
    }

    public void register(Registry registry) {
        for (Map.Entry<String, DiskUsage> entry : this.diskUsageByDevice.entrySet()) {
            final String device = entry.getKey();
            Id id = registry.createId("os.disk.usage." + device);
            id = id.withTag("device", device);
            id = id.withTag("root", this.diskUsageByDevice.get((Object)device).fsFile);
            id = id.withTag("type", this.diskUsageByDevice.get((Object)device).fsVfType);
            MixinMetric mixin = registry.mixinMetric(id);
            mixin.gauge("total.bytes", (Gauge)new Gauge<Long>(){

                public Long value() {
                    DiskUsageMetricsImporter.this.loadIfNessesary();
                    return ((DiskUsage)((DiskUsageMetricsImporter)DiskUsageMetricsImporter.this).diskUsageByDevice.get((Object)device)).totalBytes;
                }
            });
            mixin.gauge("used.bytes", (Gauge)new Gauge<Long>(){

                public Long value() {
                    DiskUsageMetricsImporter.this.loadIfNessesary();
                    return ((DiskUsage)((DiskUsageMetricsImporter)DiskUsageMetricsImporter.this).diskUsageByDevice.get((Object)device)).usedBytes;
                }
            });
            mixin.gauge("percent.used", (Gauge)new Gauge<Float>(){

                public Float value() {
                    DiskUsageMetricsImporter.this.loadIfNessesary();
                    if (((DiskUsage)((DiskUsageMetricsImporter)DiskUsageMetricsImporter.this).diskUsageByDevice.get((Object)device)).totalBytes == 0L) {
                        return Float.valueOf(0.0f);
                    }
                    float ratio = (float)((DiskUsage)((DiskUsageMetricsImporter)DiskUsageMetricsImporter.this).diskUsageByDevice.get((Object)device)).usedBytes / (float)((DiskUsage)((DiskUsageMetricsImporter)DiskUsageMetricsImporter.this).diskUsageByDevice.get((Object)device)).totalBytes;
                    return Float.valueOf(NumFormatUtils.formatFloat(ratio));
                }
            });
        }
    }

    @Override
    protected void loadValues() {
        try {
            List<String> lines = FileUtils.readFileAsStringArray(this.filePath);
            for (String line : lines) {
                String fsFile;
                String[] infos = line.split(SPLIT);
                if (infos == null || infos.length != 6 || IGNORE_FS_TYPES.contains(infos[DiskMounts.FS_VF_TYPE.ordinal()]) || infos[DiskMounts.FS_VF_TYPE.ordinal()].startsWith("fuse.") || (fsFile = infos[DiskMounts.FS_FILE.ordinal()]).startsWith("/dev") || fsFile.startsWith("/sys") || fsFile.startsWith("/proc") || fsFile.startsWith("/lib") || fsFile.startsWith("net:")) continue;
                DiskUsage diskUsage = new DiskUsage();
                diskUsage.fsSpec = infos[DiskMounts.FS_SPEC.ordinal()];
                diskUsage.fsVfType = infos[DiskMounts.FS_VF_TYPE.ordinal()];
                diskUsage.fsFile = fsFile;
                File file = new File(fsFile);
                diskUsage.totalBytes = file.getTotalSpace();
                diskUsage.usedBytes = diskUsage.totalBytes - file.getFreeSpace();
                this.diskUsageByDevice.put(diskUsage.fsSpec, diskUsage);
            }
        }
        catch (Exception e) {
            this.logger.info("warning,can't parse line at /proc/mounts", (Object)e.getMessage());
        }
    }

    private class DiskUsage {
        String fsSpec;
        String fsFile;
        String fsVfType;
        long totalBytes;
        long usedBytes;

        private DiskUsage() {
        }
    }

    private static enum DiskMounts {
        FS_SPEC,
        FS_FILE,
        FS_VF_TYPE,
        FS_MN_OPS,
        FS_FREQ,
        FS_PASS_NO;

    }
}

