/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.os.linux;

import com.alipay.lookout.api.Gauge;
import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.Registry;
import com.alipay.lookout.api.composite.MixinMetric;
import com.alipay.lookout.common.log.LookoutLoggerFactory;
import com.alipay.lookout.os.CachedMetricsImporter;
import com.alipay.lookout.os.utils.FileUtils;
import com.alipay.lookout.os.utils.NumFormatUtils;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class SystemLoadMetricsImporter
extends CachedMetricsImporter {
    private final Logger logger = LookoutLoggerFactory.getLogger(SystemLoadMetricsImporter.class);
    private static final String DEFAULT_FILE_PATH = "/proc/loadavg";
    private static final Pattern loadPattern = Pattern.compile("^([\\d\\.]+)\\s+([\\d\\.]+)\\s+([\\d\\.]+)\\s+[\\d]+/[\\d]+\\s+([\\d]+).*$", 32);
    private String filePath;
    private float[] loadAvg;

    public SystemLoadMetricsImporter() {
        this(DEFAULT_FILE_PATH, DEFAULT_TIMEOUT_MS, TimeUnit.MILLISECONDS);
    }

    public SystemLoadMetricsImporter(String filePath, long timeout, TimeUnit timeoutUnit) {
        super(timeout, timeoutUnit);
        this.filePath = filePath;
        this.loadAvg = new float[LoadAvg.values().length];
    }

    public void register(Registry registry) {
        Id id = registry.createId("os.systemload.average");
        MixinMetric mixin = registry.mixinMetric(id);
        mixin.gauge("1min", (Gauge)new Gauge<Float>(){

            public Float value() {
                SystemLoadMetricsImporter.this.loadIfNessesary();
                return Float.valueOf(SystemLoadMetricsImporter.this.loadAvg[LoadAvg.ONE_MIN.ordinal()]);
            }
        });
        mixin.gauge("5min", (Gauge)new Gauge<Float>(){

            public Float value() {
                SystemLoadMetricsImporter.this.loadIfNessesary();
                return Float.valueOf(SystemLoadMetricsImporter.this.loadAvg[LoadAvg.FIVE_MIN.ordinal()]);
            }
        });
        mixin.gauge("15min", (Gauge)new Gauge<Float>(){

            public Float value() {
                SystemLoadMetricsImporter.this.loadIfNessesary();
                return Float.valueOf(SystemLoadMetricsImporter.this.loadAvg[LoadAvg.FIFTEEN_MIN.ordinal()]);
            }
        });
    }

    @Override
    protected void loadValues() {
        try {
            String loadDetails = FileUtils.readFile(this.filePath);
            Matcher loadMatcher = loadPattern.matcher(loadDetails);
            if (loadMatcher.matches()) {
                this.loadAvg[LoadAvg.ONE_MIN.ordinal()] = NumFormatUtils.formatFloat(loadMatcher.group(1));
                this.loadAvg[LoadAvg.FIVE_MIN.ordinal()] = NumFormatUtils.formatFloat(loadMatcher.group(2));
                this.loadAvg[LoadAvg.FIFTEEN_MIN.ordinal()] = NumFormatUtils.formatFloat(loadMatcher.group(3));
            }
        }
        catch (Exception e) {
            this.logger.info("warning,can't parse text at /proc/loadavg", (Object)e.getMessage());
        }
    }

    private static enum LoadAvg {
        ONE_MIN,
        FIVE_MIN,
        FIFTEEN_MIN;

    }
}

