/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.mongo.framework.dao.impl;

import com.lorne.core.framework.model.Page;
import com.lorne.mongo.framework.dao.MongoBaseDao;
import com.lorne.mongo.framework.entity.MongoEntity;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;

public class MongoBaseDaoImpl<T extends MongoEntity>
implements MongoBaseDao<T> {
    @Autowired
    protected MongoTemplate mongoTemplate;
    protected Class clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    @Override
    public void saveOrUpdate(T t) {
        this.mongoTemplate.save(t);
    }

    @Override
    public List<T> findAll() {
        Query query = new Query();
        return this.mongoTemplate.find(query, this.clazz);
    }

    @Override
    public void saveOrUpdate(T t, String tableName) {
        this.mongoTemplate.save(t, tableName);
    }

    @Override
    public List<T> findAll(String tableName) {
        Query query = new Query();
        return this.mongoTemplate.find(query, this.clazz, tableName);
    }

    @Override
    public Page<T> pageForBeanList(Query query, int nowPage, int pageSize) {
        return this.pageForBeanList(query, nowPage, pageSize);
    }

    @Override
    public Page<T> pageForBeanList(Query query, int nowPage, int pageSize, String tableName) {
        Page page = new Page();
        long count = StringUtils.isEmpty((String)tableName) ? this.mongoTemplate.count(query, this.clazz) : this.mongoTemplate.count(query, this.clazz, tableName);
        page.setTotal((int)count);
        PageRequest pageable = new PageRequest(nowPage - 1, pageSize);
        query.with((Pageable)pageable);
        List list = StringUtils.isEmpty((String)tableName) ? this.mongoTemplate.find(query, this.clazz) : this.mongoTemplate.find(query, this.clazz, tableName);
        page.setRows((Collection)list);
        page.setNowPage(nowPage);
        page.setPageSize(pageSize);
        long pageNumber = 0L;
        if (count > 0L) {
            pageNumber = count % (long)pageSize == 0L ? count / (long)pageSize : count / (long)pageSize + 1L;
        }
        page.setPageNumber((int)pageNumber);
        return page;
    }

    @Override
    public void remove(T t) {
        this.mongoTemplate.remove(t);
    }

    @Override
    public void remove(T t, String tableName) {
        this.mongoTemplate.remove(t, tableName);
    }

    @Override
    public void dropTable() {
        this.mongoTemplate.dropCollection(this.clazz);
    }

    @Override
    public void dropTable(String tableName) {
        this.mongoTemplate.dropCollection(tableName);
    }
}

