/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.swaggerbootstrapui.filter;

import com.github.xiaoymin.swaggerbootstrapui.conf.Consts;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;

public class BasicFilter
implements Consts {
    private Logger logger = LoggerFactory.getLogger(BasicFilter.class);
    protected List<String> urlFilters = new ArrayList<String>();

    public BasicFilter() {
        this.urlFilters.add(".*?/doc\\.html.*");
        this.urlFilters.add(".*?/v2/api-docs.*");
        this.urlFilters.add(".*?/v2/api-docs-ext.*");
        this.urlFilters.add(".*?/swagger-resources.*");
        this.urlFilters.add(".*?/swagger-ui\\.html.*");
        this.urlFilters.add(".*?/swagger-resources/configuration/ui.*");
        this.urlFilters.add(".*?/swagger-resources/configuration/security.*");
    }

    protected boolean match(String uri) {
        boolean match = false;
        if (uri != null) {
            for (String regex : this.getUrlFilters()) {
                if (!uri.matches(regex)) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    protected String decodeBase64(String source) {
        String decodeStr = null;
        if (source != null) {
            BASE64Decoder decoder = new BASE64Decoder();
            try {
                byte[] bytes = decoder.decodeBuffer(source);
                decodeStr = new String(bytes);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return decodeStr;
    }

    public List<String> getUrlFilters() {
        return this.urlFilters;
    }

    public void setUrlFilters(List<String> urlFilters) {
        this.urlFilters = urlFilters;
    }
}

