/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin2.internal.Nullable;

public final class Node<V> {
    Node<V> parent;
    V value;
    List<Node<V>> children = Collections.emptyList();
    static final MergeFunction FIRST_NOT_NULL = new MergeFunction(){

        public Object merge(@Nullable Object existing, @Nullable Object update) {
            return existing != null ? existing : update;
        }
    };

    Node(@Nullable V value) {
        this.value = value;
    }

    @Nullable
    public Node<V> parent() {
        return this.parent;
    }

    @Nullable
    public V value() {
        return this.value;
    }

    public Node<V> setValue(V newValue) {
        if (newValue == null) {
            throw new NullPointerException("newValue == null");
        }
        this.value = newValue;
        return this;
    }

    public Node<V> addChild(Node<V> child) {
        if (child == this) {
            throw new IllegalArgumentException("circular dependency on " + this);
        }
        child.parent = this;
        if (this.children.equals(Collections.emptyList())) {
            this.children = new ArrayList<Node<V>>();
        }
        this.children.add(child);
        return this;
    }

    public Collection<Node<V>> children() {
        return this.children;
    }

    public Iterator<Node<V>> traverse() {
        return new BreadthFirstIterator(this);
    }

    public String toString() {
        return "Node{parent=" + this.parent + ", value=" + this.value + ", children=" + this.children + "}";
    }

    static final class Entry<V> {
        @Nullable
        final String parentId;
        final String id;
        final V value;

        Entry(@Nullable String parentId, String id, V value) {
            if (id == null) {
                throw new NullPointerException("id == null");
            }
            if (value == null) {
                throw new NullPointerException("value == null");
            }
            this.parentId = parentId;
            this.id = id;
            this.value = value;
        }

        public String toString() {
            return "Entry{parentId=" + this.parentId + ", id=" + this.id + ", value=" + this.value + "}";
        }
    }

    public static final class TreeBuilder<V> {
        final Logger logger;
        final MergeFunction<V> mergeFunction;
        final String traceId;
        String rootId = null;
        Node<V> rootNode = null;
        List<Entry<V>> entries = new ArrayList<Entry<V>>();
        Map<String, Node<V>> idToNode = new LinkedHashMap<String, Node<V>>();
        Map<String, String> idToParent = new LinkedHashMap<String, String>(this.idToNode.size());

        public TreeBuilder(Logger logger, String traceId) {
            this(logger, FIRST_NOT_NULL, traceId);
        }

        TreeBuilder(Logger logger, MergeFunction<V> mergeFunction, String traceId) {
            this.logger = logger;
            this.mergeFunction = mergeFunction;
            this.traceId = traceId;
        }

        public boolean addNode(@Nullable String parentId, String id, V value) {
            if (parentId != null && parentId.equals(id)) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(String.format("skipping circular dependency: traceId=%s, spanId=%s", this.traceId, id));
                }
                return false;
            }
            this.idToParent.put(id, parentId);
            this.entries.add(new Entry<V>(parentId, id, value));
            return true;
        }

        void processNode(Entry<V> entry) {
            String parentId = entry.parentId != null ? entry.parentId : this.idToParent.get(entry.id);
            String id = entry.id;
            Object value = entry.value;
            if (parentId == null) {
                if (this.rootId != null) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine(String.format("attributing span missing parent to root: traceId=%s, rootSpanId=%s, spanId=%s", this.traceId, this.rootId, id));
                    }
                } else {
                    this.rootId = id;
                }
            }
            Node<V> node = new Node<V>(value);
            if (parentId == null && this.rootNode == null) {
                this.rootNode = node;
                this.rootId = id;
                this.idToParent.remove(id);
            } else if (parentId == null && this.rootId.equals(id)) {
                this.rootNode.setValue(this.mergeFunction.merge(this.rootNode.value, node.value));
            } else {
                Node previous = this.idToNode.put(id, node);
                if (previous != null) {
                    node.setValue(this.mergeFunction.merge(previous.value, node.value));
                }
            }
        }

        public Node<V> build() {
            int length = this.entries.size();
            for (int i = 0; i < length; ++i) {
                this.processNode(this.entries.get(i));
            }
            for (Map.Entry<String, String> entry : this.idToParent.entrySet()) {
                Node<V> node = this.idToNode.get(entry.getKey());
                Node<V> parent = this.idToNode.get(entry.getValue());
                if (parent == null) {
                    if (this.rootNode == null) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine("substituting dummy node for missing root span: traceId=" + this.traceId);
                        }
                        this.rootNode = new Node<Object>(null);
                    }
                    this.rootNode.addChild(node);
                    continue;
                }
                parent.addChild(node);
            }
            return this.rootNode != null ? this.rootNode : new Node<Object>(null);
        }
    }

    static interface MergeFunction<V> {
        public V merge(@Nullable V var1, @Nullable V var2);
    }

    static final class BreadthFirstIterator<V>
    implements Iterator<Node<V>> {
        private final Queue<Node<V>> queue = new ArrayDeque<Node<V>>();

        BreadthFirstIterator(Node<V> root) {
            this.queue.add(root);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public Node<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Node<V> result = this.queue.remove();
            this.queue.addAll(result.children);
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

