/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.cache.CacheManagerCustomizer;
import org.springframework.cache.CacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

class CacheManagerCustomizers
implements ApplicationContextAware {
    private ConfigurableApplicationContext applicationContext;

    CacheManagerCustomizers() {
    }

    public <T extends CacheManager> T customize(T cacheManager) {
        List<CacheManagerCustomizer<CacheManager>> customizers = this.findCustomizers(cacheManager);
        AnnotationAwareOrderComparator.sort(customizers);
        for (CacheManagerCustomizer<CacheManager> customizer : customizers) {
            customizer.customize(cacheManager);
        }
        return cacheManager;
    }

    private List<CacheManagerCustomizer<CacheManager>> findCustomizers(CacheManager cacheManager) {
        if (this.applicationContext == null) {
            return Collections.emptyList();
        }
        Class<?> cacheManagerClass = cacheManager.getClass();
        ArrayList<CacheManagerCustomizer<CacheManager>> customizers = new ArrayList<CacheManagerCustomizer<CacheManager>>();
        for (CacheManagerCustomizer customizer : this.getBeans(CacheManagerCustomizer.class)) {
            if (!this.canCustomize(customizer, cacheManagerClass)) continue;
            customizers.add(customizer);
        }
        return customizers;
    }

    private <T> Collection<T> getBeans(Class<T> type) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext.getBeanFactory(), type).values();
    }

    private boolean canCustomize(CacheManagerCustomizer<?> customizer, Class<?> cacheManagerClass) {
        Class target = GenericTypeResolver.resolveTypeArgument(customizer.getClass(), CacheManagerCustomizer.class);
        return target == null || target.isAssignableFrom(cacheManagerClass);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        }
    }
}

