/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import io.netty.util.ThreadDeathWatcher;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.index.reindex.ReindexPlugin;
import org.elasticsearch.join.ParentJoinPlugin;
import org.elasticsearch.percolator.PercolatorPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.mustache.MustachePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class TransportClientFactoryBean
implements FactoryBean<TransportClient>,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(TransportClientFactoryBean.class);
    private String clusterNodes = "127.0.0.1:9300";
    private String clusterName = "elasticsearch";
    private Boolean clientTransportSniff = true;
    private Boolean clientIgnoreClusterName = Boolean.FALSE;
    private String clientPingTimeout = "5s";
    private String clientNodesSamplerInterval = "5s";
    private TransportClient client;
    private Properties properties;
    static final String COLON = ":";
    static final String COMMA = ",";

    public void destroy() throws Exception {
        try {
            logger.info("Closing elasticSearch  client");
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            logger.error("Error closing ElasticSearch client: ", (Throwable)e);
        }
    }

    public TransportClient getObject() throws Exception {
        return this.client;
    }

    public Class<TransportClient> getObjectType() {
        return TransportClient.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        this.buildClient();
    }

    protected void buildClient() throws Exception {
        this.client = new SpringDataTransportClient(this.settings());
        Assert.hasText((String)this.clusterNodes, (String)"[Assertion failed] clusterNodes settings missing.");
        for (String clusterNode : StringUtils.split((String)this.clusterNodes, (String)COMMA)) {
            String hostName = StringUtils.substringBeforeLast((String)clusterNode, (String)COLON);
            String port = StringUtils.substringAfterLast((String)clusterNode, (String)COLON);
            Assert.hasText((String)hostName, (String)"[Assertion failed] missing host name in 'clusterNodes'");
            Assert.hasText((String)port, (String)"[Assertion failed] missing port in 'clusterNodes'");
            logger.info("adding transport node : " + clusterNode);
            this.client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(hostName), Integer.valueOf(port).intValue()));
        }
        this.client.connectedNodes();
    }

    private Settings settings() {
        if (this.properties != null) {
            return Settings.builder().put((Dictionary)this.properties).build();
        }
        return Settings.builder().put("cluster.name", this.clusterName).put("client.transport.sniff", this.clientTransportSniff.booleanValue()).put("client.transport.ignore_cluster_name", this.clientIgnoreClusterName.booleanValue()).put("client.transport.ping_timeout", this.clientPingTimeout).put("client.transport.nodes_sampler_interval", this.clientNodesSamplerInterval).build();
    }

    public void setClusterNodes(String clusterNodes) {
        this.clusterNodes = clusterNodes;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setClientTransportSniff(Boolean clientTransportSniff) {
        this.clientTransportSniff = clientTransportSniff;
    }

    public String getClientNodesSamplerInterval() {
        return this.clientNodesSamplerInterval;
    }

    public void setClientNodesSamplerInterval(String clientNodesSamplerInterval) {
        this.clientNodesSamplerInterval = clientNodesSamplerInterval;
    }

    public String getClientPingTimeout() {
        return this.clientPingTimeout;
    }

    public void setClientPingTimeout(String clientPingTimeout) {
        this.clientPingTimeout = clientPingTimeout;
    }

    public Boolean getClientIgnoreClusterName() {
        return this.clientIgnoreClusterName;
    }

    public void setClientIgnoreClusterName(Boolean clientIgnoreClusterName) {
        this.clientIgnoreClusterName = clientIgnoreClusterName;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    private static class SpringDataTransportClient
    extends TransportClient {
        private static final List<String> OPTIONAL_DEPENDENCIES = Arrays.asList("org.elasticsearch.transport.Netty3Plugin", "org.elasticsearch.transport.Netty4Plugin");
        private static final Collection<Class<? extends Plugin>> PRE_INSTALLED_PLUGINS;

        private static void initializeNetty() {
            SpringDataTransportClient.setSystemPropertyIfUnset("io.netty.noUnsafe", Boolean.toString(true));
            SpringDataTransportClient.setSystemPropertyIfUnset("io.netty.noKeySetOptimization", Boolean.toString(true));
            SpringDataTransportClient.setSystemPropertyIfUnset("io.netty.recycler.maxCapacityPerThread", Integer.toString(0));
        }

        @SuppressForbidden(reason="set system properties to configure Netty")
        private static void setSystemPropertyIfUnset(String key, String value) {
            String currentValue = System.getProperty(key);
            if (currentValue == null) {
                System.setProperty(key, value);
            }
        }

        public SpringDataTransportClient(Settings settings) {
            super(settings, PRE_INSTALLED_PLUGINS);
        }

        public void close() {
            super.close();
            if (!NetworkModule.TRANSPORT_TYPE_SETTING.exists(this.settings) || ((String)NetworkModule.TRANSPORT_TYPE_SETTING.get(this.settings)).equals("netty4")) {
                try {
                    GlobalEventExecutor.INSTANCE.awaitInactivity(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                try {
                    ThreadDeathWatcher.awaitInactivity((long)5L, (TimeUnit)TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        static {
            SpringDataTransportClient.initializeNetty();
            ArrayList<Class> plugins = new ArrayList<Class>();
            boolean found = false;
            for (String dependency : OPTIONAL_DEPENDENCIES) {
                try {
                    plugins.add(ClassUtils.forName((String)dependency, (ClassLoader)SpringDataTransportClient.class.getClassLoader()));
                    found = true;
                }
                catch (ClassNotFoundException | LinkageError throwable) {}
            }
            Assert.state((boolean)found, (String)"Neither Netty 3 or Netty 4 plugin found on the classpath. One of them is required to run the transport client!");
            plugins.add(ReindexPlugin.class);
            plugins.add(PercolatorPlugin.class);
            plugins.add(MustachePlugin.class);
            plugins.add(ParentJoinPlugin.class);
            PRE_INSTALLED_PLUGINS = Collections.unmodifiableList(plugins);
        }
    }
}

