/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.repository.query.AbstractElasticsearchRepositoryQuery;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchQueryMethod;
import org.springframework.data.elasticsearch.repository.query.parser.ElasticsearchQueryCreator;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.StreamUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ElasticsearchPartQuery
extends AbstractElasticsearchRepositoryQuery {
    private static final int DEFAULT_STREAM_BATCH_SIZE = 500;
    private final PartTree tree;
    private final MappingContext<?, ElasticsearchPersistentProperty> mappingContext;

    public ElasticsearchPartQuery(ElasticsearchQueryMethod method, ElasticsearchOperations elasticsearchOperations) {
        super(method, elasticsearchOperations);
        this.tree = new PartTree(method.getName(), method.getEntityInformation().getJavaType());
        this.mappingContext = elasticsearchOperations.getElasticsearchConverter().getMappingContext();
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        CriteriaQuery query = this.createQuery(accessor);
        Assert.notNull((Object)query, (String)"unsupported query");
        if (this.tree.isDelete()) {
            Object result = this.countOrGetDocumentsForDelete(query, accessor);
            this.elasticsearchOperations.delete(query, this.queryMethod.getEntityInformation().getJavaType());
            return result;
        }
        if (this.queryMethod.isPageQuery()) {
            query.setPageable(accessor.getPageable());
            return this.elasticsearchOperations.queryForPage(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        if (this.queryMethod.isStreamQuery()) {
            Class entityType = this.queryMethod.getEntityInformation().getJavaType();
            if (accessor.getPageable().isUnpaged()) {
                query.setPageable((Pageable)PageRequest.of((int)0, (int)500));
            } else {
                query.setPageable(accessor.getPageable());
            }
            return StreamUtils.createStreamFromIterator(this.elasticsearchOperations.stream(query, entityType));
        }
        if (this.queryMethod.isCollectionQuery()) {
            if (accessor.getPageable().isUnpaged()) {
                int itemCount = (int)this.elasticsearchOperations.count(query, this.queryMethod.getEntityInformation().getJavaType());
                query.setPageable((Pageable)PageRequest.of((int)0, (int)Math.max(1, itemCount)));
            } else {
                query.setPageable(accessor.getPageable());
            }
            return this.elasticsearchOperations.queryForList(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        if (this.tree.isCountProjection()) {
            return this.elasticsearchOperations.count(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        return this.elasticsearchOperations.queryForObject(query, this.queryMethod.getEntityInformation().getJavaType());
    }

    private Object countOrGetDocumentsForDelete(CriteriaQuery query, ParametersParameterAccessor accessor) {
        Object result = null;
        if (this.queryMethod.isCollectionQuery()) {
            if (accessor.getPageable().isUnpaged()) {
                int itemCount = (int)this.elasticsearchOperations.count(query, this.queryMethod.getEntityInformation().getJavaType());
                query.setPageable((Pageable)PageRequest.of((int)0, (int)Math.max(1, itemCount)));
            } else {
                query.setPageable(accessor.getPageable());
            }
            result = this.elasticsearchOperations.queryForList(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        if (ClassUtils.isAssignable(Number.class, (Class)this.queryMethod.getReturnedObjectType())) {
            result = this.elasticsearchOperations.count(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        return result;
    }

    public CriteriaQuery createQuery(ParametersParameterAccessor accessor) {
        return (CriteriaQuery)new ElasticsearchQueryCreator(this.tree, (ParameterAccessor)accessor, this.mappingContext).createQuery();
    }
}

