/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bson.BSONObject;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.InvalidMongoDbApiUsageException;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Field;
import org.springframework.data.mongodb.core.query.Meta;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Query {
    private static final String RESTRICTED_TYPES_KEY = "_$RESTRICTED_TYPES";
    private final Set<Class<?>> restrictedTypes = new HashSet();
    private final Map<String, CriteriaDefinition> criteria = new LinkedHashMap<String, CriteriaDefinition>();
    private Field fieldSpec;
    private Sort sort;
    private int skip;
    private int limit;
    private String hint;
    private Meta meta = new Meta();

    public static Query query(CriteriaDefinition criteriaDefinition) {
        return new Query(criteriaDefinition);
    }

    public Query() {
    }

    public Query(CriteriaDefinition criteriaDefinition) {
        this.addCriteria(criteriaDefinition);
    }

    public Query addCriteria(CriteriaDefinition criteriaDefinition) {
        CriteriaDefinition existing = this.criteria.get(criteriaDefinition.getKey());
        String key = criteriaDefinition.getKey();
        if (existing != null) {
            throw new InvalidMongoDbApiUsageException("Due to limitations of the com.mongodb.BasicDBObject, you can't add a second '" + key + "' criteria. Query already contains '" + existing.getCriteriaObject() + "'.");
        }
        this.criteria.put(key, criteriaDefinition);
        return this;
    }

    public Field fields() {
        if (this.fieldSpec == null) {
            this.fieldSpec = new Field();
        }
        return this.fieldSpec;
    }

    public Query skip(int skip) {
        this.skip = skip;
        return this;
    }

    public Query limit(int limit) {
        this.limit = limit;
        return this;
    }

    public Query withHint(String name) {
        Assert.hasText((String)name, (String)"Hint must not be empty or null!");
        this.hint = name;
        return this;
    }

    public Query with(Pageable pageable) {
        if (pageable == null) {
            return this;
        }
        this.limit = pageable.getPageSize();
        this.skip = pageable.getOffset();
        return this.with(pageable.getSort());
    }

    public Query with(Sort sort) {
        if (sort == null) {
            return this;
        }
        for (Sort.Order order : sort) {
            if (!order.isIgnoreCase()) continue;
            throw new IllegalArgumentException(String.format("Given sort contained an Order for %s with ignore case! MongoDB does not support sorting ignoreing case currently!", order.getProperty()));
        }
        this.sort = this.sort == null ? sort : this.sort.and(sort);
        return this;
    }

    public Set<Class<?>> getRestrictedTypes() {
        return this.restrictedTypes == null ? Collections.emptySet() : this.restrictedTypes;
    }

    public Query restrict(Class<?> type, Class<?> ... additionalTypes) {
        Assert.notNull(type, (String)"Type must not be null!");
        Assert.notNull(additionalTypes, (String)"AdditionalTypes must not be null");
        this.restrictedTypes.add(type);
        for (Class<?> additionalType : additionalTypes) {
            this.restrictedTypes.add(additionalType);
        }
        return this;
    }

    public DBObject getQueryObject() {
        BasicDBObject dbo = new BasicDBObject();
        for (CriteriaDefinition definition : this.criteria.values()) {
            dbo.putAll((BSONObject)definition.getCriteriaObject());
        }
        if (!this.restrictedTypes.isEmpty()) {
            dbo.put(RESTRICTED_TYPES_KEY, this.getRestrictedTypes());
        }
        return dbo;
    }

    public DBObject getFieldsObject() {
        return this.fieldSpec == null ? null : this.fieldSpec.getFieldsObject();
    }

    public DBObject getSortObject() {
        if (this.sort == null) {
            return null;
        }
        BasicDBObject dbo = new BasicDBObject();
        for (Sort.Order order : this.sort) {
            dbo.put(order.getProperty(), (Object)(order.isAscending() ? 1 : -1));
        }
        return dbo;
    }

    public int getSkip() {
        return this.skip;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getHint() {
        return this.hint;
    }

    public Query maxTimeMsec(long maxTimeMsec) {
        this.meta.setMaxTimeMsec(maxTimeMsec);
        return this;
    }

    public Query maxTime(long timeout, TimeUnit timeUnit) {
        this.meta.setMaxTime(timeout, timeUnit);
        return this;
    }

    public Query maxScan(long maxScan) {
        this.meta.setMaxScan(maxScan);
        return this;
    }

    public Query comment(String comment) {
        this.meta.setComment(comment);
        return this;
    }

    public Query useSnapshot() {
        this.meta.setSnapshot(true);
        return this;
    }

    public Query noCursorTimeout() {
        this.meta.addFlag(Meta.CursorOption.NO_TIMEOUT);
        return this;
    }

    public Query exhaust() {
        this.meta.addFlag(Meta.CursorOption.EXHAUST);
        return this;
    }

    public Query slaveOk() {
        this.meta.addFlag(Meta.CursorOption.SLAVE_OK);
        return this;
    }

    public Query partialResults() {
        this.meta.addFlag(Meta.CursorOption.PARTIAL);
        return this;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public void setMeta(Meta meta) {
        Assert.notNull((Object)meta, (String)"Query meta might be empty but must not be null.");
        this.meta = meta;
    }

    protected List<CriteriaDefinition> getCriteria() {
        return new ArrayList<CriteriaDefinition>(this.criteria.values());
    }

    public String toString() {
        return String.format("Query: %s, Fields: %s, Sort: %s", SerializationUtils.serializeToJsonSafely(this.getQueryObject()), SerializationUtils.serializeToJsonSafely(this.getFieldsObject()), SerializationUtils.serializeToJsonSafely(this.getSortObject()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.querySettingsEquals((Query)obj);
    }

    protected boolean querySettingsEquals(Query that) {
        boolean criteriaEqual = this.criteria.equals(that.criteria);
        boolean fieldsEqual = ObjectUtils.nullSafeEquals((Object)this.fieldSpec, (Object)that.fieldSpec);
        boolean sortEqual = ObjectUtils.nullSafeEquals((Object)this.sort, (Object)that.sort);
        boolean hintEqual = ObjectUtils.nullSafeEquals((Object)this.hint, (Object)that.hint);
        boolean skipEqual = this.skip == that.skip;
        boolean limitEqual = this.limit == that.limit;
        boolean metaEqual = ObjectUtils.nullSafeEquals((Object)this.meta, (Object)that.meta);
        return criteriaEqual && fieldsEqual && sortEqual && hintEqual && skipEqual && limitEqual && metaEqual;
    }

    public int hashCode() {
        int result = 17;
        result += 31 * this.criteria.hashCode();
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.fieldSpec);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.sort);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.hint);
        result += 31 * this.skip;
        result += 31 * this.limit;
        return result += 31 * ObjectUtils.nullSafeHashCode((Object)this.meta);
    }

    @Deprecated
    public static boolean isRestrictedTypeKey(String key) {
        return RESTRICTED_TYPES_KEY.equals(key);
    }
}

