/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.util.Assert;

public class GeoNearOperation
implements AggregationOperation {
    private final NearQuery nearQuery;
    private final String distanceField;

    public GeoNearOperation(NearQuery nearQuery, String distanceField) {
        Assert.notNull((Object)nearQuery, (String)"NearQuery must not be null.");
        Assert.hasLength((String)distanceField, (String)"Distance field must not be null or empty.");
        this.nearQuery = nearQuery;
        this.distanceField = distanceField;
    }

    @Override
    public DBObject toDBObject(AggregationOperationContext context) {
        BasicDBObject command = (BasicDBObject)context.getMappedObject(this.nearQuery.toDBObject());
        command.put("distanceField", (Object)this.distanceField);
        return new BasicDBObject("$geoNear", (Object)command);
    }
}

