/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.BasicDBObject;
import com.mongodb.BulkWriteException;
import com.mongodb.BulkWriteOperation;
import com.mongodb.BulkWriteRequestBuilder;
import com.mongodb.BulkWriteResult;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.DefaultWriteConcernResolver;
import org.springframework.data.mongodb.core.MongoAction;
import org.springframework.data.mongodb.core.MongoActionOperation;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.WriteConcernResolver;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.UpdateMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.Pair;
import org.springframework.util.Assert;

class DefaultBulkOperations
implements BulkOperations {
    private final MongoOperations mongoOperations;
    private final String collectionName;
    private final BulkOperationContext bulkOperationContext;
    private PersistenceExceptionTranslator exceptionTranslator;
    private WriteConcernResolver writeConcernResolver;
    private WriteConcern defaultWriteConcern;
    private BulkWriteOperation bulk;

    DefaultBulkOperations(MongoOperations mongoOperations, String collectionName, BulkOperationContext bulkOperationContext) {
        Assert.notNull((Object)mongoOperations, (String)"MongoOperations must not be null!");
        Assert.hasText((String)collectionName, (String)"CollectionName must not be null nor empty!");
        Assert.notNull((Object)bulkOperationContext, (String)"BulkOperationContext must not be null!");
        this.mongoOperations = mongoOperations;
        this.collectionName = collectionName;
        this.bulkOperationContext = bulkOperationContext;
        this.exceptionTranslator = new MongoExceptionTranslator();
        this.writeConcernResolver = DefaultWriteConcernResolver.INSTANCE;
        this.bulk = this.getBulkWriteOptions(bulkOperationContext.getBulkMode());
    }

    public void setExceptionTranslator(PersistenceExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator == null ? new MongoExceptionTranslator() : exceptionTranslator;
    }

    public void setWriteConcernResolver(WriteConcernResolver writeConcernResolver) {
        this.writeConcernResolver = writeConcernResolver == null ? DefaultWriteConcernResolver.INSTANCE : writeConcernResolver;
    }

    void setDefaultWriteConcern(WriteConcern defaultWriteConcern) {
        this.defaultWriteConcern = defaultWriteConcern;
    }

    @Override
    public BulkOperations insert(Object document) {
        Assert.notNull((Object)document, (String)"Document must not be null!");
        if (document instanceof DBObject) {
            this.bulk.insert((DBObject)document);
            return this;
        }
        BasicDBObject sink = new BasicDBObject();
        this.mongoOperations.getConverter().write(document, sink);
        this.bulk.insert((DBObject)sink);
        return this;
    }

    @Override
    public BulkOperations insert(List<? extends Object> documents) {
        Assert.notNull(documents, (String)"Documents must not be null!");
        for (Object object : documents) {
            this.insert(object);
        }
        return this;
    }

    @Override
    public BulkOperations updateOne(Query query, Update update) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)update, (String)"Update must not be null!");
        return this.updateOne(Collections.singletonList(Pair.of((Object)query, (Object)update)));
    }

    @Override
    public BulkOperations updateOne(List<Pair<Query, Update>> updates) {
        Assert.notNull(updates, (String)"Updates must not be null!");
        for (Pair<Query, Update> update : updates) {
            this.update((Query)update.getFirst(), (Update)update.getSecond(), false, false);
        }
        return this;
    }

    @Override
    public BulkOperations updateMulti(Query query, Update update) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)update, (String)"Update must not be null!");
        return this.updateMulti(Collections.singletonList(Pair.of((Object)query, (Object)update)));
    }

    @Override
    public BulkOperations updateMulti(List<Pair<Query, Update>> updates) {
        Assert.notNull(updates, (String)"Updates must not be null!");
        for (Pair<Query, Update> update : updates) {
            this.update((Query)update.getFirst(), (Update)update.getSecond(), false, true);
        }
        return this;
    }

    @Override
    public BulkOperations upsert(Query query, Update update) {
        return this.update(query, update, true, true);
    }

    @Override
    public BulkOperations upsert(List<Pair<Query, Update>> updates) {
        for (Pair<Query, Update> update : updates) {
            this.upsert((Query)update.getFirst(), (Update)update.getSecond());
        }
        return this;
    }

    @Override
    public BulkOperations remove(Query query) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        this.bulk.find(this.getMappedQuery(query.getQueryObject())).remove();
        return this;
    }

    @Override
    public BulkOperations remove(List<Query> removes) {
        Assert.notNull(removes, (String)"Removals must not be null!");
        for (Query query : removes) {
            this.remove(query);
        }
        return this;
    }

    @Override
    public BulkWriteResult execute() {
        MongoAction action = new MongoAction(this.defaultWriteConcern, MongoActionOperation.BULK, this.collectionName, this.bulkOperationContext.getEntityType(), null, null);
        WriteConcern writeConcern = this.writeConcernResolver.resolve(action);
        try {
            BulkWriteResult bulkWriteResult = writeConcern == null ? this.bulk.execute() : this.bulk.execute(writeConcern);
            return bulkWriteResult;
        }
        catch (BulkWriteException o_O) {
            DataAccessException toThrow = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw toThrow == null ? o_O : toThrow;
        }
        finally {
            this.bulk = this.getBulkWriteOptions(this.bulkOperationContext.getBulkMode());
        }
    }

    private BulkOperations update(Query query, Update update, boolean upsert, boolean multi) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)update, (String)"Update must not be null!");
        BulkWriteRequestBuilder builder = this.bulk.find(this.getMappedQuery(query.getQueryObject()));
        if (upsert) {
            if (multi) {
                builder.upsert().update(this.getMappedUpdate(update.getUpdateObject()));
            } else {
                builder.upsert().updateOne(this.getMappedUpdate(update.getUpdateObject()));
            }
        } else if (multi) {
            builder.update(this.getMappedUpdate(update.getUpdateObject()));
        } else {
            builder.updateOne(this.getMappedUpdate(update.getUpdateObject()));
        }
        return this;
    }

    private DBObject getMappedUpdate(DBObject update) {
        return this.bulkOperationContext.getUpdateMapper().getMappedObject(update, this.bulkOperationContext.getEntity());
    }

    private DBObject getMappedQuery(DBObject query) {
        return this.bulkOperationContext.getQueryMapper().getMappedObject(query, this.bulkOperationContext.getEntity());
    }

    private BulkWriteOperation getBulkWriteOptions(BulkOperations.BulkMode bulkMode) {
        DBCollection collection = this.mongoOperations.getCollection(this.collectionName);
        switch (bulkMode) {
            case ORDERED: {
                return collection.initializeOrderedBulkOperation();
            }
            case UNORDERED: {
                return collection.initializeUnorderedBulkOperation();
            }
        }
        throw new IllegalStateException("BulkMode was null!");
    }

    static final class BulkOperationContext {
        @NonNull
        private final BulkOperations.BulkMode bulkMode;
        private final MongoPersistentEntity<?> entity;
        @NonNull
        private final QueryMapper queryMapper;
        @NonNull
        private final UpdateMapper updateMapper;

        Class<?> getEntityType() {
            return this.entity != null ? this.entity.getType() : null;
        }

        @ConstructorProperties(value={"bulkMode", "entity", "queryMapper", "updateMapper"})
        public BulkOperationContext(@NonNull BulkOperations.BulkMode bulkMode, MongoPersistentEntity<?> entity, @NonNull QueryMapper queryMapper, @NonNull UpdateMapper updateMapper) {
            if (bulkMode == null) {
                throw new IllegalArgumentException("bulkMode is null");
            }
            if (queryMapper == null) {
                throw new IllegalArgumentException("queryMapper is null");
            }
            if (updateMapper == null) {
                throw new IllegalArgumentException("updateMapper is null");
            }
            this.bulkMode = bulkMode;
            this.entity = entity;
            this.queryMapper = queryMapper;
            this.updateMapper = updateMapper;
        }

        @NonNull
        public BulkOperations.BulkMode getBulkMode() {
            return this.bulkMode;
        }

        public MongoPersistentEntity<?> getEntity() {
            return this.entity;
        }

        @NonNull
        public QueryMapper getQueryMapper() {
            return this.queryMapper;
        }

        @NonNull
        public UpdateMapper getUpdateMapper() {
            return this.updateMapper;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BulkOperationContext)) {
                return false;
            }
            BulkOperationContext other = (BulkOperationContext)o;
            BulkOperations.BulkMode this$bulkMode = this.getBulkMode();
            BulkOperations.BulkMode other$bulkMode = other.getBulkMode();
            if (this$bulkMode == null ? other$bulkMode != null : !((Object)((Object)this$bulkMode)).equals((Object)other$bulkMode)) {
                return false;
            }
            MongoPersistentEntity<?> this$entity = this.getEntity();
            MongoPersistentEntity<?> other$entity = other.getEntity();
            if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
                return false;
            }
            QueryMapper this$queryMapper = this.getQueryMapper();
            QueryMapper other$queryMapper = other.getQueryMapper();
            if (this$queryMapper == null ? other$queryMapper != null : !this$queryMapper.equals(other$queryMapper)) {
                return false;
            }
            UpdateMapper this$updateMapper = this.getUpdateMapper();
            UpdateMapper other$updateMapper = other.getUpdateMapper();
            return !(this$updateMapper == null ? other$updateMapper != null : !this$updateMapper.equals(other$updateMapper));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BulkOperations.BulkMode $bulkMode = this.getBulkMode();
            result = result * 59 + ($bulkMode == null ? 43 : ((Object)((Object)$bulkMode)).hashCode());
            MongoPersistentEntity<?> $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
            QueryMapper $queryMapper = this.getQueryMapper();
            result = result * 59 + ($queryMapper == null ? 43 : $queryMapper.hashCode());
            UpdateMapper $updateMapper = this.getUpdateMapper();
            result = result * 59 + ($updateMapper == null ? 43 : $updateMapper.hashCode());
            return result;
        }

        public String toString() {
            return "DefaultBulkOperations.BulkOperationContext(bulkMode=" + (Object)((Object)this.getBulkMode()) + ", entity=" + this.getEntity() + ", queryMapper=" + this.getQueryMapper() + ", updateMapper=" + this.getUpdateMapper() + ")";
        }
    }
}

