/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping.event;

import com.mongodb.DBObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.query.SerializationUtils;

public class LoggingEventListener
extends AbstractMongoEventListener<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingEventListener.class);

    @Override
    public void onBeforeConvert(Object source) {
        LOGGER.info("onBeforeConvert: {}", source);
    }

    @Override
    public void onBeforeSave(Object source, DBObject dbo) {
        LOGGER.info("onBeforeSave: {}, {}", source, (Object)SerializationUtils.serializeToJsonSafely(dbo));
    }

    @Override
    public void onAfterSave(Object source, DBObject dbo) {
        LOGGER.info("onAfterSave: {}, {}", source, (Object)SerializationUtils.serializeToJsonSafely(dbo));
    }

    @Override
    public void onAfterLoad(DBObject dbo) {
        LOGGER.info("onAfterLoad: {}", (Object)SerializationUtils.serializeToJsonSafely(dbo));
    }

    @Override
    public void onAfterConvert(DBObject dbo, Object source) {
        LOGGER.info("onAfterConvert: {}, {}", (Object)SerializationUtils.serializeToJsonSafely(dbo), source);
    }

    @Override
    public void onAfterDelete(DBObject dbo) {
        LOGGER.info("onAfterDelete: {}", (Object)SerializationUtils.serializeToJsonSafely(dbo));
    }

    @Override
    public void onBeforeDelete(DBObject dbo) {
        LOGGER.info("onBeforeDelete: {}", (Object)SerializationUtils.serializeToJsonSafely(dbo));
    }
}

