/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.reactivestreams.client.Success;
import com.mongodb.reactivestreams.client.gridfs.AsyncInputStream;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BiConsumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;

class AsyncInputStreamAdapter
implements AsyncInputStream {
    private static final AtomicLongFieldUpdater<AsyncInputStreamAdapter> DEMAND = AtomicLongFieldUpdater.newUpdater(AsyncInputStreamAdapter.class, "demand");
    private static final AtomicIntegerFieldUpdater<AsyncInputStreamAdapter> SUBSCRIBED = AtomicIntegerFieldUpdater.newUpdater(AsyncInputStreamAdapter.class, "subscribed");
    private static final int SUBSCRIPTION_NOT_SUBSCRIBED = 0;
    private static final int SUBSCRIPTION_SUBSCRIBED = 1;
    private final Publisher<? extends DataBuffer> buffers;
    private final Context subscriberContext;
    private final DefaultDataBufferFactory factory = new DefaultDataBufferFactory();
    private volatile Subscription subscription;
    private volatile boolean cancelled;
    private volatile boolean complete;
    private volatile Throwable error;
    private final Queue<BiConsumer<DataBuffer, Integer>> readRequests = (Queue)Queues.small().get();
    volatile long demand;
    volatile int subscribed = 0;

    public Publisher<Integer> read(ByteBuffer dst) {
        return Mono.create(sink -> {
            this.readRequests.offer((db, bytecount) -> {
                try {
                    if (this.error != null) {
                        sink.error(this.error);
                        return;
                    }
                    if (bytecount == -1) {
                        sink.success((Object)-1);
                        return;
                    }
                    ByteBuffer byteBuffer = db.asByteBuffer();
                    int toWrite = byteBuffer.remaining();
                    dst.put(byteBuffer);
                    sink.success((Object)toWrite);
                }
                catch (Exception e) {
                    sink.error((Throwable)e);
                }
                finally {
                    DataBufferUtils.release((DataBuffer)db);
                }
            });
            this.request(1);
        });
    }

    public Publisher<Long> skip(long bytesToSkip) {
        throw new UnsupportedOperationException("Skip is currently not implemented");
    }

    public Publisher<Success> close() {
        return Mono.create(sink -> {
            this.cancelled = true;
            if (this.error != null) {
                sink.error(this.error);
                return;
            }
            sink.success((Object)Success.SUCCESS);
        });
    }

    protected void request(int n) {
        if (this.complete) {
            this.terminatePendingReads();
            return;
        }
        Operators.addCap(DEMAND, (Object)this, (long)n);
        if (SUBSCRIBED.get(this) == 0) {
            if (SUBSCRIBED.compareAndSet(this, 0, 1)) {
                this.buffers.subscribe((Subscriber)new DataBufferCoreSubscriber());
            }
        } else {
            Subscription subscription = this.subscription;
            if (subscription != null) {
                this.requestFromSubscription(subscription);
            }
        }
    }

    void requestFromSubscription(Subscription subscription) {
        long demand = DEMAND.get(this);
        if (this.cancelled) {
            subscription.cancel();
        }
        if (demand > 0L && DEMAND.compareAndSet(this, demand, demand - 1L)) {
            subscription.request(1L);
        }
    }

    void terminatePendingReads() {
        BiConsumer<DataBuffer, Integer> readers;
        while ((readers = this.readRequests.poll()) != null) {
            readers.accept((DataBuffer)this.factory.wrap(new byte[0]), -1);
        }
    }

    public AsyncInputStreamAdapter(Publisher<? extends DataBuffer> buffers, Context subscriberContext) {
        this.buffers = buffers;
        this.subscriberContext = subscriberContext;
    }

    private class DataBufferCoreSubscriber
    implements CoreSubscriber<DataBuffer> {
        private DataBufferCoreSubscriber() {
        }

        public Context currentContext() {
            return AsyncInputStreamAdapter.this.subscriberContext;
        }

        public void onSubscribe(Subscription s) {
            AsyncInputStreamAdapter.this.subscription = s;
            Operators.addCap((AtomicLongFieldUpdater)DEMAND, (Object)AsyncInputStreamAdapter.this, (long)-1L);
            s.request(1L);
        }

        public void onNext(DataBuffer dataBuffer) {
            if (AsyncInputStreamAdapter.this.cancelled || AsyncInputStreamAdapter.this.complete) {
                DataBufferUtils.release((DataBuffer)dataBuffer);
                Operators.onNextDropped((Object)dataBuffer, (Context)AsyncInputStreamAdapter.this.subscriberContext);
                return;
            }
            BiConsumer poll = (BiConsumer)AsyncInputStreamAdapter.this.readRequests.poll();
            if (poll == null) {
                DataBufferUtils.release((DataBuffer)dataBuffer);
                Operators.onNextDropped((Object)dataBuffer, (Context)AsyncInputStreamAdapter.this.subscriberContext);
                AsyncInputStreamAdapter.this.subscription.cancel();
                return;
            }
            poll.accept(dataBuffer, dataBuffer.readableByteCount());
            AsyncInputStreamAdapter.this.requestFromSubscription(AsyncInputStreamAdapter.this.subscription);
        }

        public void onError(Throwable t) {
            if (AsyncInputStreamAdapter.this.cancelled || AsyncInputStreamAdapter.this.complete) {
                Operators.onErrorDropped((Throwable)t, (Context)AsyncInputStreamAdapter.this.subscriberContext);
                return;
            }
            AsyncInputStreamAdapter.this.error = t;
            AsyncInputStreamAdapter.this.complete = true;
            AsyncInputStreamAdapter.this.terminatePendingReads();
        }

        public void onComplete() {
            AsyncInputStreamAdapter.this.complete = true;
            AsyncInputStreamAdapter.this.terminatePendingReads();
        }
    }
}

