/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alipay.sofa.rpc.module;

import com.alipay.sofa.rpc.ext.Extensible;

/**
 * 模块扩展，RPC上下文会自动加载，例如tracer，metric，都属于此类扩展。
 *
 * @author <a href="mailto:zhanggeng.zg@antfin.com">GengZhang</a>
 * @since 5.2.0
 */
@Extensible
public interface Module {

    /**
     * 是否需要满足加载条件
     *
     * @return 是否
     */
    public boolean needLoad();

    /**
     * 安装模板
     */
    public void install();

    /**
     * 卸载模块
     */
    public void uninstall();
}
