/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.jdpay.kit;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.XmlUtil;
import cn.hutool.crypto.SecureUtil;
import com.ijpay.core.kit.WxPayKit;
import com.ijpay.jdpay.util.SignUtil;
import com.ijpay.jdpay.util.ThreeDesUtil;
import com.ijpay.jdpay.util.XmlEncryptUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Document;

public class JdPayKit {
    public static String md5LowerCase(String data) {
        return SecureUtil.md5((String)data).toLowerCase();
    }

    public static String toJdXml(Map<String, String> params) {
        return WxPayKit.forEachMap(params, "<jdpay>", "</jdpay>").toString();
    }

    public static String encrypt(String rsaPrivateKey, String strDesKey, String genSignStr) {
        return XmlEncryptUtil.encrypt(rsaPrivateKey, strDesKey, genSignStr);
    }

    public static String decrypt(String rsaPubKey, String strDesKey, String encrypt) {
        return XmlEncryptUtil.decrypt(rsaPubKey, strDesKey, encrypt);
    }

    public static String decrypt(String rsaPubKey, String reqBody) {
        return XmlEncryptUtil.decrypt(rsaPubKey, reqBody);
    }

    public static String signRemoveSelectedKeys(Map<String, String> map, String rsaPriKey, List<String> unSignKeyList) {
        return SignUtil.signRemoveSelectedKeys(map, rsaPriKey, unSignKeyList);
    }

    public static String threeDesEncrypt(String desKey, String sourceData) {
        byte[] key = Base64.decode((CharSequence)desKey);
        return ThreeDesUtil.encrypt2HexStr(key, sourceData);
    }

    public static String threeDecDecrypt(String desKey, String sourceData) {
        byte[] key = Base64.decode((CharSequence)desKey);
        return ThreeDesUtil.decrypt4HexStr(key, sourceData);
    }

    public static Map<String, String> threeDesToMap(Map<String, String> map, String desKey) {
        HashMap<String, String> tempMap = new HashMap<String, String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!StrUtil.isNotEmpty((CharSequence)value)) continue;
            if ("merchant".equals(name) || "version".equals(name) || "sign".equals(name)) {
                tempMap.put(name, value);
                continue;
            }
            tempMap.put(name, JdPayKit.threeDesEncrypt(desKey, value));
        }
        return tempMap;
    }

    public static Map<String, String> parseResp(String xml) {
        if (StrUtil.isEmpty((CharSequence)xml)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(3);
        Document docResult = XmlUtil.parseXml((String)xml);
        String code = (String)XmlUtil.getByXPath((String)"//jdpay/result/code", (Object)docResult, (QName)XPathConstants.STRING);
        String desc = (String)XmlUtil.getByXPath((String)"//jdpay/result/desc", (Object)docResult, (QName)XPathConstants.STRING);
        map.put("code", code);
        map.put("desc", desc);
        if ("000000".equals(code)) {
            String encrypt = (String)XmlUtil.getByXPath((String)"//jdpay/encrypt", (Object)docResult, (QName)XPathConstants.STRING);
            map.put("encrypt", encrypt);
        }
        return map;
    }
}

