/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.mockwebserver;

import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.NamedRunnable;
import com.squareup.okhttp.internal.Platform;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.spdy.ErrorCode;
import com.squareup.okhttp.internal.spdy.Header;
import com.squareup.okhttp.internal.spdy.IncomingStreamHandler;
import com.squareup.okhttp.internal.spdy.SpdyConnection;
import com.squareup.okhttp.internal.spdy.SpdyStream;
import com.squareup.okhttp.mockwebserver.Dispatcher;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.PushPromise;
import com.squareup.okhttp.mockwebserver.QueueDispatcher;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import com.squareup.okhttp.mockwebserver.SocketPolicy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;

public final class MockWebServer {
    private static final X509TrustManager UNTRUSTED_TRUST_MANAGER = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
            throw new AssertionError();
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            throw new AssertionError();
        }
    };
    private static final Logger logger = Logger.getLogger(MockWebServer.class.getName());
    private final BlockingQueue<RecordedRequest> requestQueue = new LinkedBlockingQueue<RecordedRequest>();
    private final Map<Socket, Boolean> openClientSockets = new ConcurrentHashMap<Socket, Boolean>();
    private final Map<SpdyConnection, Boolean> openSpdyConnections = new ConcurrentHashMap<SpdyConnection, Boolean>();
    private final AtomicInteger requestCount = new AtomicInteger();
    private int bodyLimit = Integer.MAX_VALUE;
    private ServerSocket serverSocket;
    private SSLSocketFactory sslSocketFactory;
    private ExecutorService executor;
    private boolean tunnelProxy;
    private Dispatcher dispatcher = new QueueDispatcher();
    private int port = -1;
    private boolean protocolNegotiationEnabled = true;
    private List<Protocol> protocols = Util.immutableList((Object[])new Protocol[]{Protocol.HTTP_2, Protocol.SPDY_3, Protocol.HTTP_1_1});

    public int getPort() {
        if (this.port == -1) {
            throw new IllegalStateException("Cannot retrieve port before calling play()");
        }
        return this.port;
    }

    public String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Proxy toProxyAddress() {
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getHostName(), this.getPort()));
    }

    public URL getUrl(String path) {
        try {
            return this.sslSocketFactory != null ? new URL("https://" + this.getHostName() + ":" + this.getPort() + path) : new URL("http://" + this.getHostName() + ":" + this.getPort() + path);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getCookieDomain() {
        String hostName = this.getHostName();
        return hostName.contains(".") ? hostName : ".local";
    }

    public void setBodyLimit(int maxBodyLength) {
        this.bodyLimit = maxBodyLength;
    }

    public void setNpnEnabled(boolean npnEnabled) {
        this.protocolNegotiationEnabled = npnEnabled;
    }

    public void setProtocolNegotiationEnabled(boolean protocolNegotiationEnabled) {
        this.protocolNegotiationEnabled = protocolNegotiationEnabled;
    }

    public void setNpnProtocols(List<Protocol> protocols) {
        this.setProtocols(protocols);
    }

    public void setProtocols(List<Protocol> protocols) {
        if (!(protocols = Util.immutableList(protocols)).contains(Protocol.HTTP_1_1)) {
            throw new IllegalArgumentException("protocols doesn't contain http/1.1: " + protocols);
        }
        if (protocols.contains(null)) {
            throw new IllegalArgumentException("protocols must not contain null");
        }
        this.protocols = protocols;
    }

    public void useHttps(SSLSocketFactory sslSocketFactory, boolean tunnelProxy) {
        this.sslSocketFactory = sslSocketFactory;
        this.tunnelProxy = tunnelProxy;
    }

    public RecordedRequest takeRequest() throws InterruptedException {
        return this.requestQueue.take();
    }

    public int getRequestCount() {
        return this.requestCount.get();
    }

    public void enqueue(MockResponse response) {
        ((QueueDispatcher)this.dispatcher).enqueueResponse(response.clone());
    }

    public void play() throws IOException {
        this.play(0);
    }

    public void play(int port) throws IOException {
        if (this.executor != null) {
            throw new IllegalStateException("play() already called");
        }
        this.executor = Executors.newCachedThreadPool(Util.threadFactory((String)"MockWebServer", (boolean)false));
        this.serverSocket = new ServerSocket(port);
        this.serverSocket.setReuseAddress(true);
        this.port = this.serverSocket.getLocalPort();
        this.executor.execute((Runnable)new NamedRunnable("MockWebServer %s", new Object[]{port}){

            protected void execute() {
                try {
                    this.acceptConnections();
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "MockWebServer connection failed", e);
                }
                Util.closeQuietly((ServerSocket)MockWebServer.this.serverSocket);
                Iterator s = MockWebServer.this.openClientSockets.keySet().iterator();
                while (s.hasNext()) {
                    Util.closeQuietly((Socket)((Socket)s.next()));
                    s.remove();
                }
                s = MockWebServer.this.openSpdyConnections.keySet().iterator();
                while (s.hasNext()) {
                    Util.closeQuietly((Closeable)((Closeable)s.next()));
                    s.remove();
                }
                MockWebServer.this.executor.shutdown();
            }

            private void acceptConnections() throws Exception {
                while (true) {
                    Socket socket;
                    try {
                        socket = MockWebServer.this.serverSocket.accept();
                    }
                    catch (SocketException e) {
                        return;
                    }
                    SocketPolicy socketPolicy = MockWebServer.this.dispatcher.peek().getSocketPolicy();
                    if (socketPolicy == SocketPolicy.DISCONNECT_AT_START) {
                        MockWebServer.this.dispatchBookkeepingRequest(0, socket);
                        socket.close();
                        continue;
                    }
                    MockWebServer.this.openClientSockets.put(socket, true);
                    MockWebServer.this.serveConnection(socket);
                }
            }
        });
    }

    public void shutdown() throws IOException {
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }

    private void serveConnection(final Socket raw) {
        this.executor.execute((Runnable)new NamedRunnable("MockWebServer %s", new Object[]{raw.getRemoteSocketAddress()}){
            int sequenceNumber;
            {
                super(x0, x1);
                this.sequenceNumber = 0;
            }

            protected void execute() {
                try {
                    this.processConnection();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "MockWebServer connection failed", e);
                }
            }

            public void processConnection() throws Exception {
                Socket socket;
                Protocol protocol = Protocol.HTTP_1_1;
                if (MockWebServer.this.sslSocketFactory != null) {
                    SocketPolicy socketPolicy;
                    if (MockWebServer.this.tunnelProxy) {
                        this.createTunnel();
                    }
                    if ((socketPolicy = MockWebServer.this.dispatcher.peek().getSocketPolicy()) == SocketPolicy.FAIL_HANDSHAKE) {
                        MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber, raw);
                        MockWebServer.this.processHandshakeFailure(raw);
                        return;
                    }
                    socket = MockWebServer.this.sslSocketFactory.createSocket(raw, raw.getInetAddress().getHostAddress(), raw.getPort(), true);
                    SSLSocket sslSocket = (SSLSocket)socket;
                    sslSocket.setUseClientMode(false);
                    MockWebServer.this.openClientSockets.put(socket, true);
                    if (MockWebServer.this.protocolNegotiationEnabled) {
                        Platform.get().setProtocols(sslSocket, MockWebServer.this.protocols);
                    }
                    sslSocket.startHandshake();
                    if (MockWebServer.this.protocolNegotiationEnabled) {
                        String protocolString = Platform.get().getSelectedProtocol(sslSocket);
                        protocol = protocolString != null ? Protocol.get((String)protocolString) : Protocol.HTTP_1_1;
                    }
                    MockWebServer.this.openClientSockets.remove(raw);
                } else {
                    socket = raw;
                }
                if (protocol != Protocol.HTTP_1_1) {
                    SpdySocketHandler spdySocketHandler = new SpdySocketHandler(socket, protocol);
                    SpdyConnection spdyConnection = new SpdyConnection.Builder(false, socket).protocol(protocol).handler((IncomingStreamHandler)spdySocketHandler).build();
                    MockWebServer.this.openSpdyConnections.put(spdyConnection, Boolean.TRUE);
                    MockWebServer.this.openClientSockets.remove(socket);
                    return;
                }
                BufferedInputStream in = new BufferedInputStream(socket.getInputStream());
                BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
                while (this.processOneRequest(socket, in, out)) {
                }
                if (this.sequenceNumber == 0) {
                    logger.warning("MockWebServer connection didn't make a request");
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
                socket.close();
                MockWebServer.this.openClientSockets.remove(socket);
            }

            private void createTunnel() throws IOException, InterruptedException {
                SocketPolicy socketPolicy;
                do {
                    socketPolicy = MockWebServer.this.dispatcher.peek().getSocketPolicy();
                    if (this.processOneRequest(raw, raw.getInputStream(), raw.getOutputStream())) continue;
                    throw new IllegalStateException("Tunnel without any CONNECT!");
                } while (socketPolicy != SocketPolicy.UPGRADE_TO_SSL_AT_END);
            }

            private boolean processOneRequest(Socket socket, InputStream in, OutputStream out) throws IOException, InterruptedException {
                RecordedRequest request = MockWebServer.this.readRequest(socket, in, out, this.sequenceNumber);
                if (request == null) {
                    return false;
                }
                MockWebServer.this.requestCount.incrementAndGet();
                MockWebServer.this.requestQueue.add(request);
                MockResponse response = MockWebServer.this.dispatcher.dispatch(request);
                if (response.getSocketPolicy() == SocketPolicy.DISCONNECT_AFTER_REQUEST) {
                    socket.close();
                    return false;
                }
                MockWebServer.this.writeResponse(out, response);
                if (response.getSocketPolicy() == SocketPolicy.DISCONNECT_AT_END) {
                    in.close();
                    out.close();
                } else if (response.getSocketPolicy() == SocketPolicy.SHUTDOWN_INPUT_AT_END) {
                    socket.shutdownInput();
                } else if (response.getSocketPolicy() == SocketPolicy.SHUTDOWN_OUTPUT_AT_END) {
                    socket.shutdownOutput();
                }
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Received request: " + request + " and responded: " + response);
                }
                ++this.sequenceNumber;
                return true;
            }
        });
    }

    private void processHandshakeFailure(Socket raw) throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{UNTRUSTED_TRUST_MANAGER}, new SecureRandom());
        SSLSocketFactory sslSocketFactory = context.getSocketFactory();
        SSLSocket socket = (SSLSocket)sslSocketFactory.createSocket(raw, raw.getInetAddress().getHostAddress(), raw.getPort(), true);
        try {
            socket.startHandshake();
            throw new AssertionError();
        }
        catch (IOException expected) {
            socket.close();
            return;
        }
    }

    private void dispatchBookkeepingRequest(int sequenceNumber, Socket socket) throws InterruptedException {
        this.requestCount.incrementAndGet();
        this.dispatcher.dispatch(new RecordedRequest(null, null, null, -1L, null, sequenceNumber, socket));
    }

    private RecordedRequest readRequest(Socket socket, InputStream in, OutputStream out, int sequenceNumber) throws IOException {
        String header;
        String request;
        try {
            request = this.readAsciiUntilCrlf(in);
        }
        catch (IOException streamIsClosed) {
            return null;
        }
        if (request.length() == 0) {
            return null;
        }
        ArrayList<String> headers = new ArrayList<String>();
        long contentLength = -1L;
        boolean chunked = false;
        boolean expectContinue = false;
        while ((header = this.readAsciiUntilCrlf(in)).length() != 0) {
            headers.add(header);
            String lowercaseHeader = header.toLowerCase(Locale.US);
            if (contentLength == -1L && lowercaseHeader.startsWith("content-length:")) {
                contentLength = Long.parseLong(header.substring(15).trim());
            }
            if (lowercaseHeader.startsWith("transfer-encoding:") && lowercaseHeader.substring(18).trim().equals("chunked")) {
                chunked = true;
            }
            if (!lowercaseHeader.startsWith("expect:") || !lowercaseHeader.substring(7).trim().equals("100-continue")) continue;
            expectContinue = true;
        }
        if (expectContinue) {
            out.write("HTTP/1.1 100 Continue\r\n".getBytes(Util.US_ASCII));
            out.write("Content-Length: 0\r\n".getBytes(Util.US_ASCII));
            out.write("\r\n".getBytes(Util.US_ASCII));
            out.flush();
        }
        boolean hasBody = false;
        TruncatingOutputStream requestBody = new TruncatingOutputStream();
        ArrayList<Integer> chunkSizes = new ArrayList<Integer>();
        MockResponse throttlePolicy = this.dispatcher.peek();
        if (contentLength != -1L) {
            hasBody = true;
            this.throttledTransfer(throttlePolicy, in, requestBody, contentLength);
        } else if (chunked) {
            hasBody = true;
            while (true) {
                int chunkSize;
                if ((chunkSize = Integer.parseInt(this.readAsciiUntilCrlf(in).trim(), 16)) == 0) {
                    this.readEmptyLine(in);
                    break;
                }
                chunkSizes.add(chunkSize);
                this.throttledTransfer(throttlePolicy, in, requestBody, chunkSize);
                this.readEmptyLine(in);
            }
        }
        if (request.startsWith("OPTIONS ") || request.startsWith("GET ") || request.startsWith("HEAD ") || request.startsWith("TRACE ") || request.startsWith("CONNECT ")) {
            if (hasBody) {
                throw new IllegalArgumentException("Request must not have a body: " + request);
            }
        } else if (!(request.startsWith("POST ") || request.startsWith("PUT ") || request.startsWith("PATCH ") || request.startsWith("DELETE "))) {
            throw new UnsupportedOperationException("Unexpected method: " + request);
        }
        return new RecordedRequest(request, headers, chunkSizes, requestBody.numBytesReceived, requestBody.toByteArray(), sequenceNumber, socket);
    }

    private void writeResponse(OutputStream out, MockResponse response) throws IOException {
        out.write((response.getStatus() + "\r\n").getBytes(Util.US_ASCII));
        List<String> headers = response.getHeaders();
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            String header = headers.get(i);
            out.write((header + "\r\n").getBytes(Util.US_ASCII));
        }
        out.write("\r\n".getBytes(Util.US_ASCII));
        out.flush();
        InputStream in = response.getBodyStream();
        if (in == null) {
            return;
        }
        this.throttledTransfer(response, in, out, Long.MAX_VALUE);
    }

    /*
     * Unable to fully structure code
     */
    private void throttledTransfer(MockResponse throttlePolicy, InputStream in, OutputStream out, long limit) throws IOException {
        buffer = new byte[1024];
        bytesPerPeriod = throttlePolicy.getThrottleBytesPerPeriod();
        delayMs = throttlePolicy.getThrottleUnit().toMillis(throttlePolicy.getThrottlePeriod());
        while (true) {
            for (b = 0; b < bytesPerPeriod; b += read) {
                toRead = (int)Math.min(Math.min((long)buffer.length, limit), (long)(bytesPerPeriod - b));
                read = in.read(buffer, 0, toRead);
                if (read == -1) {
                    return;
                }
                out.write(buffer, 0, read);
                out.flush();
                if ((limit -= (long)read) != 0L) continue;
                return;
            }
            try {
                if (delayMs == 0L) ** continue;
                Thread.sleep(delayMs);
            }
            catch (InterruptedException e) {
                throw new AssertionError();
            }
        }
    }

    private String readAsciiUntilCrlf(InputStream in) throws IOException {
        StringBuilder builder = new StringBuilder();
        while (true) {
            int c;
            if ((c = in.read()) == 10 && builder.length() > 0 && builder.charAt(builder.length() - 1) == '\r') {
                builder.deleteCharAt(builder.length() - 1);
                return builder.toString();
            }
            if (c == -1) {
                return builder.toString();
            }
            builder.append((char)c);
        }
    }

    private void readEmptyLine(InputStream in) throws IOException {
        String line = this.readAsciiUntilCrlf(in);
        if (line.length() != 0) {
            throw new IllegalStateException("Expected empty but was: " + line);
        }
    }

    public void setDispatcher(Dispatcher dispatcher) {
        if (dispatcher == null) {
            throw new NullPointerException();
        }
        this.dispatcher = dispatcher;
    }

    private class SpdySocketHandler
    implements IncomingStreamHandler {
        private final Socket socket;
        private final Protocol protocol;
        private final AtomicInteger sequenceNumber = new AtomicInteger();

        private SpdySocketHandler(Socket socket, Protocol protocol) {
            this.socket = socket;
            this.protocol = protocol;
        }

        public void receive(SpdyStream stream) throws IOException {
            MockResponse response;
            RecordedRequest request = this.readRequest(stream);
            MockWebServer.this.requestQueue.add(request);
            try {
                response = MockWebServer.this.dispatcher.dispatch(request);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            this.writeResponse(stream, response);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Received request: " + request + " and responded: " + response + " protocol is " + this.protocol.toString());
            }
        }

        private RecordedRequest readRequest(SpdyStream stream) throws IOException {
            List spdyHeaders = stream.getRequestHeaders();
            ArrayList<String> httpHeaders = new ArrayList<String>();
            String method = "<:method omitted>";
            String path = "<:path omitted>";
            String version = this.protocol == Protocol.SPDY_3 ? "<:version omitted>" : "HTTP/1.1";
            int size = spdyHeaders.size();
            for (int i = 0; i < size; ++i) {
                ByteString name = ((Header)spdyHeaders.get((int)i)).name;
                String value = ((Header)spdyHeaders.get((int)i)).value.utf8();
                if (name.equals((Object)Header.TARGET_METHOD)) {
                    method = value;
                    continue;
                }
                if (name.equals((Object)Header.TARGET_PATH)) {
                    path = value;
                    continue;
                }
                if (name.equals((Object)Header.VERSION)) {
                    version = value;
                    continue;
                }
                httpHeaders.add(name.utf8() + ": " + value);
            }
            BufferedSource bodyIn = Okio.buffer((Source)stream.getSource());
            byte[] bodyOut = bodyIn.readByteArray();
            bodyIn.close();
            String requestLine = method + ' ' + path + ' ' + version;
            List<Integer> chunkSizes = Collections.emptyList();
            return new RecordedRequest(requestLine, httpHeaders, chunkSizes, bodyOut.length, bodyOut, this.sequenceNumber.getAndIncrement(), this.socket);
        }

        private void writeResponse(SpdyStream stream, MockResponse response) throws IOException {
            if (response.getSocketPolicy() == SocketPolicy.NO_RESPONSE) {
                return;
            }
            ArrayList<Header> spdyHeaders = new ArrayList<Header>();
            String[] statusParts = response.getStatus().split(" ", 2);
            if (statusParts.length != 2) {
                throw new AssertionError((Object)("Unexpected status: " + response.getStatus()));
            }
            spdyHeaders.add(new Header(Header.RESPONSE_STATUS, statusParts[1]));
            if (this.protocol == Protocol.SPDY_3) {
                spdyHeaders.add(new Header(Header.VERSION, statusParts[0]));
            }
            List<String> headers = response.getHeaders();
            int size = headers.size();
            for (int i = 0; i < size; ++i) {
                String header = headers.get(i);
                String[] headerParts = header.split(":", 2);
                if (headerParts.length != 2) {
                    throw new AssertionError((Object)("Unexpected header: " + header));
                }
                spdyHeaders.add(new Header(headerParts[0], headerParts[1]));
            }
            Buffer body = response.getBody();
            if (body == null) {
                body = new Buffer();
            }
            boolean closeStreamAfterHeaders = body.size() > 0L || !response.getPushPromises().isEmpty();
            stream.reply(spdyHeaders, closeStreamAfterHeaders);
            this.pushPromises(stream, response.getPushPromises());
            if (body.size() > 0L) {
                if (response.getBodyDelayTimeMs() != 0) {
                    try {
                        Thread.sleep(response.getBodyDelayTimeMs());
                    }
                    catch (InterruptedException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                BufferedSink sink = Okio.buffer((Sink)stream.getSink());
                if (response.getThrottleBytesPerPeriod() == Integer.MAX_VALUE) {
                    sink.writeAll((Source)body);
                    sink.flush();
                } else {
                    while (body.size() > 0L) {
                        long toWrite = Math.min(body.size(), (long)response.getThrottleBytesPerPeriod());
                        sink.write(body, toWrite);
                        sink.flush();
                        try {
                            long delayMs = response.getThrottleUnit().toMillis(response.getThrottlePeriod());
                            if (delayMs == 0L) continue;
                            Thread.sleep(delayMs);
                        }
                        catch (InterruptedException e) {
                            throw new AssertionError();
                        }
                    }
                }
                sink.close();
            } else if (closeStreamAfterHeaders) {
                stream.close(ErrorCode.NO_ERROR);
            }
        }

        private void pushPromises(SpdyStream stream, List<PushPromise> promises) throws IOException {
            for (PushPromise pushPromise : promises) {
                ArrayList<Header> pushedHeaders = new ArrayList<Header>();
                pushedHeaders.add(new Header(stream.getConnection().getProtocol() == Protocol.SPDY_3 ? Header.TARGET_HOST : Header.TARGET_AUTHORITY, MockWebServer.this.getUrl(pushPromise.getPath()).getHost()));
                pushedHeaders.add(new Header(Header.TARGET_METHOD, pushPromise.getMethod()));
                pushedHeaders.add(new Header(Header.TARGET_PATH, pushPromise.getPath()));
                int size = pushPromise.getHeaders().size();
                for (int i = 0; i < size; ++i) {
                    String header = pushPromise.getHeaders().get(i);
                    String[] headerParts = header.split(":", 2);
                    if (headerParts.length != 2) {
                        throw new AssertionError((Object)("Unexpected header: " + header));
                    }
                    pushedHeaders.add(new Header(headerParts[0], headerParts[1].trim()));
                }
                String requestLine = pushPromise.getMethod() + ' ' + pushPromise.getPath() + " HTTP/1.1";
                List<Integer> chunkSizes = Collections.emptyList();
                MockWebServer.this.requestQueue.add(new RecordedRequest(requestLine, pushPromise.getHeaders(), chunkSizes, 0L, Util.EMPTY_BYTE_ARRAY, this.sequenceNumber.getAndIncrement(), this.socket));
                Buffer pushedBody = pushPromise.getResponse().getBody();
                SpdyStream pushedStream = stream.getConnection().pushStream(stream.getId(), pushedHeaders, pushedBody.size() > 0L);
                this.writeResponse(pushedStream, pushPromise.getResponse());
            }
        }
    }

    private class TruncatingOutputStream
    extends ByteArrayOutputStream {
        private long numBytesReceived = 0L;

        private TruncatingOutputStream() {
        }

        @Override
        public void write(byte[] buffer, int offset, int len) {
            this.numBytesReceived += (long)len;
            super.write(buffer, offset, Math.min(len, MockWebServer.this.bodyLimit - this.count));
        }

        @Override
        public void write(int oneByte) {
            ++this.numBytesReceived;
            if (this.count < MockWebServer.this.bodyLimit) {
                super.write(oneByte);
            }
        }
    }
}

