/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.registry.zookeeper;

import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.registry.zookeeper.ZkNodeType;
import com.weibo.api.motan.rpc.URL;

public class ZkUtils {
    public static String toGroupPath(URL url) {
        return "/motan/" + url.getGroup();
    }

    public static String toServicePath(URL url) {
        return ZkUtils.toGroupPath(url) + "/" + url.getPath();
    }

    public static String toCommandPath(URL url) {
        return ZkUtils.toGroupPath(url) + "/command";
    }

    public static String toNodeTypePath(URL url, ZkNodeType nodeType) {
        String type;
        if (nodeType == ZkNodeType.AVAILABLE_SERVER) {
            type = "server";
        } else if (nodeType == ZkNodeType.UNAVAILABLE_SERVER) {
            type = "unavailableServer";
        } else if (nodeType == ZkNodeType.CLIENT) {
            type = "client";
        } else {
            throw new MotanFrameworkException(String.format("Failed to get nodeTypePath, url: %s type: %s", url, nodeType.toString()));
        }
        return ZkUtils.toServicePath(url) + "/" + type;
    }

    public static String toNodePath(URL url, ZkNodeType nodeType) {
        return ZkUtils.toNodeTypePath(url, nodeType) + "/" + url.getServerPortStr();
    }
}

