/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.extract;

import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.extract.CommonsArchiveEntryAdapter;
import de.flapdoodle.embed.process.extract.FilesToExtract;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.extract.IExtractionMatch;
import de.flapdoodle.embed.process.extract.IExtractor;
import de.flapdoodle.embed.process.extract.ImmutableExtractedFileSet;
import de.flapdoodle.embed.process.io.progress.IProgressListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExtractor
implements IExtractor {
    private static Logger _logger = LoggerFactory.getLogger(AbstractExtractor.class);

    protected abstract ArchiveWrapper archiveStream(File var1) throws FileNotFoundException, IOException;

    private ArchiveWrapper archiveStreamWithExceptionHint(File source) throws FileNotFoundException, IOException {
        try {
            return this.archiveStream(source);
        }
        catch (IOException iox) {
            _logger.warn("\n--------------------------\nIf you get this exception more than once, you should check if the file is corrupt.\nIf you remove the file ({}), it will be downloaded again.\n--------------------------", (Object)source.getAbsolutePath(), (Object)iox);
            throw new IOException("File " + source.getAbsolutePath(), iox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExtractedFileSet extract(IDownloadConfig runtime, File source, FilesToExtract toExtract) throws IOException {
        ImmutableExtractedFileSet.Builder builder = ImmutableExtractedFileSet.builder(toExtract.baseDir()).baseDirIsGenerated(toExtract.baseDirIsGenerated());
        IProgressListener progressListener = runtime.getProgressListener();
        String progressLabel = "Extract " + source;
        progressListener.start(progressLabel);
        try (ArchiveWrapper archive = this.archiveStreamWithExceptionHint(source);){
            ArchiveEntry entry;
            while ((entry = archive.getNextEntry()) != null) {
                IExtractionMatch match = toExtract.find(new CommonsArchiveEntryAdapter(entry));
                if (match == null) continue;
                if (archive.canReadEntryData(entry)) {
                    long size = entry.getSize();
                    builder.file(match.type(), match.write(archive.asStream(entry), size));
                    progressListener.info(progressLabel, "extract " + entry.getName());
                }
                if (!toExtract.nothingLeft()) continue;
                progressListener.info(progressLabel, "nothing left");
                break;
            }
        }
        progressListener.done(progressLabel);
        return builder.build();
    }

    protected static interface ArchiveWrapper {
        public ArchiveEntry getNextEntry() throws IOException;

        public InputStream asStream(ArchiveEntry var1) throws IOException;

        public void close() throws IOException;

        public boolean canReadEntryData(ArchiveEntry var1);
    }
}

