/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.ByteBufMono;
import reactor.netty.Connection;
import reactor.netty.NettyOutbound;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientConfiguration;
import reactor.netty.http.client.HttpClientForm;
import reactor.netty.http.client.HttpClientOperations;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.tcp.TcpClient;

final class HttpClientFinalizer
extends HttpClient
implements HttpClient.RequestSender {
    final TcpClient cachedConfiguration;
    static final Function<HttpClientOperations, HttpClientResponse> RESPONSE_ONLY = ops -> {
        HttpClientFinalizer.discard(ops);
        return ops;
    };
    static final Function<ChannelOperations<?, ?>, Publisher<ByteBuf>> contentReceiver = ChannelOperations::receive;

    HttpClientFinalizer(TcpClient parent) {
        this.cachedConfiguration = parent;
    }

    @Override
    public HttpClient.RequestSender uri(String uri) {
        return new HttpClientFinalizer(this.cachedConfiguration.bootstrap(b -> HttpClientConfiguration.uri(b, uri)));
    }

    @Override
    public HttpClient.RequestSender uri(Mono<String> uri) {
        return new HttpClientFinalizer(this.cachedConfiguration.bootstrap(b -> HttpClientConfiguration.deferredConf(b, conf -> uri.map(conf::uri))));
    }

    Mono<HttpClientOperations> connect() {
        return this.cachedConfiguration.connect();
    }

    @Override
    public Mono<HttpClientResponse> response() {
        return this.connect().map(RESPONSE_ONLY);
    }

    @Override
    public <V> Flux<V> response(BiFunction<? super HttpClientResponse, ? super ByteBufFlux, ? extends Publisher<V>> receiver) {
        return this.connect().flatMapMany(resp -> Flux.from((Publisher)((Publisher)receiver.apply((HttpClientResponse)resp, resp.receive()))).doFinally(s -> HttpClientFinalizer.discard(resp)));
    }

    @Override
    public <V> Flux<V> responseConnection(BiFunction<? super HttpClientResponse, ? super Connection, ? extends Publisher<V>> receiver) {
        return this.connect().flatMapMany(resp -> Flux.from((Publisher)((Publisher)receiver.apply((HttpClientResponse)resp, (Connection)resp))));
    }

    @Override
    public ByteBufFlux responseContent() {
        return HttpClientFinalizer.content(this.cachedConfiguration, contentReceiver);
    }

    @Override
    public <V> Mono<V> responseSingle(BiFunction<? super HttpClientResponse, ? super ByteBufMono, ? extends Mono<V>> receiver) {
        return this.connect().flatMap(resp -> ((Mono)receiver.apply((HttpClientResponse)resp, resp.receive().aggregate())).doFinally(s -> HttpClientFinalizer.discard(resp)));
    }

    public HttpClientFinalizer send(Publisher<? extends ByteBuf> requestBody) {
        Objects.requireNonNull(requestBody, "requestBody");
        return this.send((T req, U out) -> out.sendObject(requestBody));
    }

    public HttpClientFinalizer send(BiFunction<? super HttpClientRequest, ? super NettyOutbound, ? extends Publisher<Void>> sender) {
        Objects.requireNonNull(sender, "requestBody");
        return new HttpClientFinalizer(this.cachedConfiguration.bootstrap(b -> HttpClientConfiguration.body(b, sender)));
    }

    public HttpClientFinalizer sendForm(BiConsumer<? super HttpClientRequest, HttpClientForm> formCallback, @Nullable Consumer<Flux<Long>> progress) {
        Objects.requireNonNull(formCallback, "formCallback");
        return this.send((T req, U out) -> {
            HttpClientOperations ops = (HttpClientOperations)out;
            return new HttpClientOperations.SendForm(ops, formCallback, progress);
        });
    }

    static ByteBufFlux content(TcpClient cachedConfiguration, Function<ChannelOperations<?, ?>, Publisher<ByteBuf>> contentReceiver) {
        Bootstrap b;
        try {
            b = cachedConfiguration.configure();
        }
        catch (Throwable t) {
            Exceptions.throwIfJvmFatal((Throwable)t);
            return ByteBufFlux.fromInbound(Mono.error((Throwable)t));
        }
        ByteBufAllocator alloc = b.config().options().getOrDefault(ChannelOption.ALLOCATOR, ByteBufAllocator.DEFAULT);
        Mono<? extends Connection> connector = cachedConfiguration.connect(b);
        return ByteBufFlux.fromInbound(connector.flatMapMany(contentReceiver), alloc);
    }

    static void discard(HttpClientOperations c) {
        if (!c.isInboundDisposed()) {
            c.discard();
        }
    }
}

