/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.compression.deflate;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.event.Listener;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.util.LimitWriteOperationsReuseBuffers;

public class DeflateCompressor {
    private int level;
    private boolean nowrap;

    public DeflateCompressor(int level, boolean nowrap) {
        this.level = level;
        this.nowrap = nowrap;
    }

    public DeflateCompressor(boolean nowrap) {
        this(9, nowrap);
    }

    public DeflateCompressor() {
        this(9, false);
    }

    public ISynchronizationPoint<Exception> compress(IO.Readable input, IO.Writable output, int bufferSize, int maxBuffers, byte priority) {
        Deflater deflater = new Deflater(this.level, this.nowrap);
        LimitWriteOperationsReuseBuffers limit = new LimitWriteOperationsReuseBuffers(output, bufferSize, maxBuffers);
        byte[] bufRead = new byte[bufferSize];
        ByteBuffer buffer = ByteBuffer.wrap(bufRead);
        AsyncWork task = input.readAsync(buffer);
        SynchronizationPoint end = new SynchronizationPoint();
        task.listenAsync((Task)new Compress(input, output, task, bufRead, deflater, limit, priority, end), true);
        return end;
    }

    private static class Compress
    extends Task.Cpu<Void, Exception> {
        private IO.Readable input;
        private IO.Writable output;
        private AsyncWork<Integer, IOException> readTask;
        private byte[] readBuf;
        private Deflater deflater;
        private LimitWriteOperationsReuseBuffers limit;
        private SynchronizationPoint<Exception> end;

        private Compress(IO.Readable input, IO.Writable output, final AsyncWork<Integer, IOException> readTask, byte[] readBuf, Deflater delfater, LimitWriteOperationsReuseBuffers limit, byte priority, SynchronizationPoint<Exception> end) {
            super("Zip compression", priority);
            this.input = input;
            this.output = output;
            this.readTask = readTask;
            this.readBuf = readBuf;
            this.deflater = delfater;
            this.limit = limit;
            this.end = end;
            end.onCancel((Listener)new Listener<CancelException>(){

                public void fire(CancelException event) {
                    readTask.unblockCancel(event);
                    this.cancel(event);
                }
            });
        }

        public Void run() throws Exception {
            if (this.readTask.isCancelled() || this.end.isCancelled()) {
                return null;
            }
            if (!this.readTask.isSuccessful()) {
                this.end.error(this.readTask.getError());
                throw (IOException)this.readTask.getError();
            }
            try {
                int nb = (Integer)this.readTask.getResult();
                int pos = 0;
                ByteBuffer writeBuf = this.limit.getBuffer();
                if (nb <= 0) {
                    this.deflater.finish();
                    while (!this.deflater.finished()) {
                        if (writeBuf == null) {
                            writeBuf = this.limit.getBuffer();
                        }
                        if ((nb = this.deflater.deflate(writeBuf.array(), pos, writeBuf.capacity() - pos)) <= 0) break;
                        if ((pos += nb) != writeBuf.capacity()) continue;
                        this.writeCompressedData(writeBuf, pos);
                        pos = 0;
                        writeBuf = null;
                    }
                    this.deflater.end();
                    this.deflater = null;
                } else {
                    this.deflater.setInput(this.readBuf, 0, nb);
                    while (!this.deflater.needsInput() && !this.end.isCancelled()) {
                        if (writeBuf == null) {
                            writeBuf = this.limit.getBuffer();
                        }
                        if ((nb = this.deflater.deflate(writeBuf.array(), pos, writeBuf.capacity() - pos)) <= 0) break;
                        if ((pos += nb) != writeBuf.capacity()) continue;
                        this.writeCompressedData(writeBuf, pos);
                        pos = 0;
                        writeBuf = null;
                    }
                }
                if (this.end.isCancelled()) {
                    return null;
                }
                if (this.deflater != null && !this.deflater.finished()) {
                    if (pos > 0) {
                        this.writeCompressedData(writeBuf, pos);
                    } else if (writeBuf != null) {
                        this.limit.freeBuffer(writeBuf);
                    }
                    AsyncWork task = this.input.readAsync(ByteBuffer.wrap(this.readBuf));
                    task.listenAsync((Task)new Compress(this.input, this.output, (AsyncWork<Integer, IOException>)task, this.readBuf, this.deflater, this.limit, this.getPriority(), this.end), true);
                } else {
                    AsyncWork write = null;
                    if (pos > 0) {
                        write = this.writeCompressedData(writeBuf, pos);
                    } else {
                        if (writeBuf != null) {
                            this.limit.freeBuffer(writeBuf);
                        }
                        write = this.limit.getLastPendingOperation();
                    }
                    if (write == null) {
                        this.end.unblock();
                    } else {
                        write.listenInline(new Runnable(){

                            @Override
                            public void run() {
                                end.unblock();
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                this.end.error(e);
                throw e;
            }
            return null;
        }

        private AsyncWork<Integer, IOException> writeCompressedData(ByteBuffer writeBuf, int nb) throws IOException {
            writeBuf.limit(nb);
            writeBuf.position(0);
            return this.limit.write(writeBuf);
        }
    }
}

