/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.module.tsne;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.api.storage.StatsStorage;
import org.deeplearning4j.api.storage.StatsStorageEvent;
import org.deeplearning4j.ui.api.FunctionType;
import org.deeplearning4j.ui.api.HttpMethod;
import org.deeplearning4j.ui.api.Route;
import org.deeplearning4j.ui.api.UIModule;
import org.deeplearning4j.ui.i18n.I18NResource;
import org.deeplearning4j.ui.views.html.tsne.Tsne;
import play.libs.Files;
import play.libs.Json;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;
import play.twirl.api.Content;

public class TsneModule
implements UIModule {
    private static final String UPLOADED_FILE = "UploadedFile";
    private Map<String, List<String>> knownSessionIDs = Collections.synchronizedMap(new LinkedHashMap());
    private List<String> uploadedFileLines = null;

    @Override
    public List<String> getCallbackTypeIDs() {
        return Collections.emptyList();
    }

    @Override
    public List<Route> getRoutes() {
        Route r1 = new Route("/tsne", HttpMethod.GET, FunctionType.Supplier, () -> Results.ok((Content)Tsne.apply()));
        Route r2 = new Route("/tsne/sessions", HttpMethod.GET, FunctionType.Supplier, this::listSessions);
        Route r3 = new Route("/tsne/coords/:sid", HttpMethod.GET, FunctionType.Function, this::getCoords);
        Route r4 = Route.request0Function("/tsne/upload", HttpMethod.POST, this::uploadFile);
        Route r5 = Route.request1Function("/tsne/post/:sid", HttpMethod.POST, this::postFile);
        return Arrays.asList(r1, r2, r3, r4, r5);
    }

    @Override
    public void reportStorageEvents(Collection<StatsStorageEvent> events) {
    }

    @Override
    public void onAttach(StatsStorage statsStorage) {
    }

    @Override
    public void onDetach(StatsStorage statsStorage) {
    }

    @Override
    public List<I18NResource> getInternationalizationResources() {
        return Collections.emptyList();
    }

    private Result listSessions() {
        ArrayList<String> list = new ArrayList<String>(this.knownSessionIDs.keySet());
        if (this.uploadedFileLines != null) {
            list.add(UPLOADED_FILE);
        }
        return Results.ok((JsonNode)Json.toJson(list));
    }

    private Result getCoords(String sessionId) {
        if (UPLOADED_FILE.equals(sessionId) && this.uploadedFileLines != null) {
            return Results.ok((JsonNode)Json.toJson(this.uploadedFileLines));
        }
        if (this.knownSessionIDs.containsKey(sessionId)) {
            return Results.ok((JsonNode)Json.toJson(this.knownSessionIDs.get(sessionId)));
        }
        return Results.ok();
    }

    private Result uploadFile(Http.Request request) {
        Http.MultipartFormData body = request.body().asMultipartFormData();
        List fileParts = body.getFiles();
        if (fileParts.isEmpty()) {
            return Results.badRequest((String)"No file uploaded");
        }
        Http.MultipartFormData.FilePart uploadedFile = (Http.MultipartFormData.FilePart)fileParts.get(0);
        String fileName = uploadedFile.getFilename();
        String contentType = uploadedFile.getContentType();
        File file = ((Files.TemporaryFile)uploadedFile.getRef()).path().toFile();
        try {
            this.uploadedFileLines = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return Results.badRequest((String)"Could not read from uploaded file");
        }
        return Results.ok((String)("File uploaded: " + fileName + ", " + contentType + ", " + file));
    }

    private Result postFile(Http.Request request, String sid) {
        List lines;
        Http.MultipartFormData body = request.body().asMultipartFormData();
        List fileParts = body.getFiles();
        if (fileParts.isEmpty()) {
            return Results.badRequest((String)"No file uploaded");
        }
        Http.MultipartFormData.FilePart uploadedFile = (Http.MultipartFormData.FilePart)fileParts.get(0);
        String fileName = uploadedFile.getFilename();
        String contentType = uploadedFile.getContentType();
        File file = ((Files.TemporaryFile)uploadedFile.getRef()).path().toFile();
        try {
            lines = this.uploadedFileLines = FileUtils.readLines((File)file);
        }
        catch (IOException e) {
            return Results.badRequest((String)"Could not read from uploaded file");
        }
        this.knownSessionIDs.put(sid, lines);
        return Results.ok((String)("File uploaded: " + fileName + ", " + contentType + ", " + file));
    }
}

