/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.play.staticroutes;

import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.nd4j.linalg.io.ClassPathResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.mvc.Result;
import play.mvc.Results;
import play.mvc.StaticFileMimeTypes;

public class Assets {
    private static final Logger log = LoggerFactory.getLogger(Assets.class);

    public static Result assetRequest(String assetsRootDirectory, String s) {
        InputStream inputStream;
        String fullPath = s.startsWith("webjars/") ? "META-INF/resources/" + s : assetsRootDirectory + s;
        try {
            inputStream = new ClassPathResource(fullPath).getInputStream();
        }
        catch (Throwable t) {
            log.warn("Could not find requested UI asset: {}", (Object)s, (Object)t);
            return Results.ok();
        }
        String fileName = FilenameUtils.getName((String)fullPath);
        Optional contentType = StaticFileMimeTypes.fileMimeTypes().forFileName(fileName);
        String ct = contentType.orElse("application/octet-stream");
        return Results.ok((InputStream)inputStream).withHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"").as(ct);
    }
}

