package com.lorne.weixin.pay.api;

import com.lorne.weixin.pay.model.WxConfig;
import com.lorne.weixin.pay.nutils.WeixinPayUtils;

import java.util.Map;

/**
 * Created by houcunlu on 2017/10/19.
 */
public class CreditCardPay extends AbstractWxPay {
    public CreditCardPay() {
    }

    public CreditCardPay(WxConfig wxConfig) {
        super(wxConfig);
    }

    /**
     * 提交刷卡支付
     *
     * @param authCode   支付码
     * @param subMchId   子商户号
     * @param deviceInfo 终端设备号(商户自定义，如门店编号)
     * @param body       商品描述
     * @param outTradeNo 商户订单号
     * @param totalFee   订单金额
     * @param timeStart  交易起始时间
     * @param timeExpire 交易结束时间
     * @return 支付请求结果
     */
    public Map<String, Object> payMicropay(
            String authCode,
            String subMchId,
            String deviceInfo,
            String body,
            String outTradeNo,
            int totalFee, String timeStart, String timeExpire) {

        // 调用微信支付API的机器IP
        String ip = "127.0.0.1";
        /**
         * 提交刷卡支付
         */
        return WeixinPayUtils.payMicropay(getPayUrl(), wxConfig, authCode, subMchId, deviceInfo, body, outTradeNo, ip, totalFee, timeStart, timeExpire);
    }

    /**
     * @Description 微信订单查询
     **/
    public Map<String, Object> queryOrder(String sub_mch_id, String out_trade_no) {
        return WeixinPayUtils.payOrderquery(getPayUrl(), wxConfig, sub_mch_id, out_trade_no);
    }

    /**
     * @Description 取消订单
     **/
    public Map<String, Object> reverseOrder(String sub_mch_id, String out_trade_no) {
        return WeixinPayUtils.reverse(getPayUrl(), wxConfig, sub_mch_id, out_trade_no);
    }

    /**
     * @Description 订单退款
     **/
    public Map<String, Object> refund(String sub_mch_id, String out_trade_no, String out_refund_no, int total_fee, int refund_fee) {
        return WeixinPayUtils.refund(getPayUrl(), wxConfig, sub_mch_id, out_trade_no, out_refund_no, total_fee, refund_fee);
    }

    /**
     * @Description 下载对账账单
     **/
    public Map<String, Object> downLoadBill(String subMchId, String bill_date, String bill_type) {
        return WeixinPayUtils.downLoadBill(getPayUrl(), wxConfig, subMchId, bill_date, bill_type);
    }
}
