package com.lorne.weixin.pay.api;

import com.lorne.weixin.pay.model.WxConfig;
import com.lorne.weixin.pay.nutils.NWeixinApiUtils;
import com.lorne.weixin.pay.nutils.WeixinPublicUtils;

import java.util.Map;

/**
 * @ClassName: APPPay
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2018/11/20 16:57
 * @Version: V1.0.0
 */
public class MiniPay extends AbstractWxPay {

    public MiniPay() {
    }

    public MiniPay(WxConfig wxConfig) {
        super(wxConfig);
    }

    /**
     * @Description 获取微信用户信息
     **/
    public Map<String, Object> jscode2session(String jsCode) {
        return WeixinPublicUtils.jscode2session(getPayUrl(), wxConfig, jsCode);
    }

    /**
     * 服务商小程序支付
     *
     * @param subMchId   子商户号
     * @param openid     用户在商户appid下的唯一标识
     * @param deviceInfo 终端设备号(商户自定义，如门店编号)
     * @param body       商品描述
     * @param outTradeNo 商户订单号
     * @param totalFee   订单金额
     * @return 支付请求结果
     */
    public Map<String, Object> payUnifiedorder(
            String subMchId,
            String openid,
            String deviceInfo,
            String body,
            String outTradeNo,
            int totalFee) {
        return NWeixinApiUtils.createOrder(getPayUrl(), wxConfig, subMchId, deviceInfo, outTradeNo, body, totalFee, openid, "JSAPI");
    }

    /**
     * 子商户小程序支付
     *
     * @param subAppid   子商户APPID
     * @param subMchId   子商户号
     * @param openid     用户在商户appid下的唯一标识
     * @param deviceInfo 终端设备号(商户自定义，如门店编号)
     * @param body       商品描述
     * @param outTradeNo 商户订单号
     * @param totalFee   订单金额
     * @return 支付请求结果
     */
    public Map<String, Object> payUnifiedorder2(String subAppid, String subMchId, String openid, String deviceInfo, String body, String outTradeNo, int totalFee) {
        return NWeixinApiUtils.createSubOrder(getPayUrl(), wxConfig, subAppid, subMchId, deviceInfo, outTradeNo, body, totalFee, openid, "JSAPI");
    }
}
