package com.lorne.weixin.pay.api;

import com.alibaba.fastjson.JSONObject;
import com.lorne.weixin.pay.model.CertificateEntity;
import com.lorne.weixin.pay.model.SubmitReqData;
import com.lorne.weixin.pay.model.UpdateSubmitReqData;
import com.lorne.weixin.pay.model.WxConfig;
import com.lorne.weixin.pay.nutils.WeixinApplyUtils;
import com.lorne.weixin.pay.util.AesGcmExample2;
import org.apache.commons.lang.StringUtils;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @ClassName: WxResource
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/4/8 23:42
 * @Version: V1.0.0
 */
public class WxMerchantAppy extends AbstractWxPay {

    public WxMerchantAppy() {
    }

    public WxMerchantAppy(WxConfig wxConfig) {
        super(wxConfig);
    }

    /**
     * @Description 微信上传图片
     * @Author wanglie
     * @Date 0:45 2019/3/26
     **/
    public String uploadMedia(File file) throws Exception {
        Map<String, Object> map = WeixinApplyUtils.upload(getPayUrl(), wxConfig, file);
        if (Objects.nonNull(map)) {
            String return_code = (String) map.get("return_code");
            String result_code = (String) map.get("result_code");
            String return_msg = (String) map.get("return_msg");
            if ("SUCCESS".equals(return_code) && "SUCCESS".equals(result_code)) {
                String mediaId = (String) map.get("media_id");
                return mediaId;
            } else {
                String err_code_des = (String) map.get("err_code_des");
                String err_msg = "[" + map.get("err_code") + "]" + map.get("err_code_des");
                throw new Exception("微信上传图片失败：" + (!StringUtils.isBlank(err_code_des) ? return_msg : err_msg));
            }
        } else {
            throw new Exception("调用微信上传图片失败");
        }
    }

    /**
     * @Description 获取商户平台证书
     * @Author wanglie
     * @Date 23:34 2019/3/25
     **/
    public CertificateEntity getcertficates() throws Exception {
        Map<String, Object> map = WeixinApplyUtils.getcertficates(getPayUrl(), wxConfig);
        if (Objects.nonNull(map)) {
            String return_code = (String) map.get("return_code");
            String result_code = (String) map.get("result_code");
            String return_msg = (String) map.get("return_msg");
            if ("SUCCESS".equals(return_code) && "SUCCESS".equals(result_code)) {
                JSONObject certificates = JSONObject.parseObject((String) map.get("certificates"));
                List<Map<String, Object>> data = (List) JSONObject.parseArray(certificates.getString("data"));
                Map<String, Object> certificateMap = new HashMap<>();
                if (data != null && !data.isEmpty()) {
                    certificateMap = data.get(0);
                }
                String serial_no = (String) certificateMap.get("serial_no");
                String effective_time = (String) certificateMap.get("effective_time");
                String expire_time = (String) certificateMap.get("expire_time");

                JSONObject encrypt_certificate = (JSONObject) certificateMap.get("encrypt_certificate");
                String algorithm = (String) encrypt_certificate.get("algorithm");
                String nonce = (String) encrypt_certificate.get("nonce");
                String associated_data = (String) encrypt_certificate.get("associated_data");
                String ciphertext = (String) encrypt_certificate.get("ciphertext");
                String cert = AesGcmExample2.aesgcmDecrypt(wxConfig.getV3key(), associated_data, nonce, ciphertext);
                CertificateEntity certificateEntity = new CertificateEntity(serial_no, effective_time, expire_time, algorithm, nonce, associated_data, ciphertext, cert);
                return certificateEntity;
            } else {
                String err_code_des = (String) map.get("err_code_des");
                String err_msg = "[" + map.get("err_code") + "]" + map.get("err_code_des");
                throw new Exception("微信获取证书失败：" + (!StringUtils.isBlank(err_code_des) ? return_msg : err_msg));
            }
        } else {
            throw new Exception("调用微信获取证书失败");
        }

    }

    /**
     * @Description 申请入驻
     * @Author wanglie
     * @Date 0:47 2019/3/26
     **/
    public Map<String, Object> submit(
            String cert_sn,
            String business_code,
            String id_card_copy,
            String id_card_national,
            String id_card_name,
            String id_card_number,
            String id_card_valid_time,
            String account_name,
            String account_bank,
            String bank_address_code,
            String bank_name,
            String account_number,
            String store_name,
            String store_address_code,
            String store_street,
            String store_entrance_pic,
            String indoor_pic,
            String address_certification,
            String merchant_shortname,
            String service_phone,
            String product_desc,
            String contact,
            String contact_phone,
            String contact_email
    ) {
        return WeixinApplyUtils.submit(wxConfig, getPayUrl(), new SubmitReqData(wxConfig.getMchId(), wxConfig.getRate(), wxConfig.getKey(), cert_sn, business_code, id_card_copy, id_card_national, id_card_name, id_card_number, id_card_valid_time,
                account_name, account_bank, bank_address_code, bank_name, account_number, store_name, store_address_code, store_street, store_entrance_pic, indoor_pic, address_certification,
                merchant_shortname, service_phone, product_desc, contact, contact_phone, contact_email));
    }

    /**
     * @Description 查询申请状态
     * @Author wanglie
     * @Date 0:49 2019/4/9
     **/
    public Map<String, Object> getstate(String applyment_id, String business_code) {
        return WeixinApplyUtils.getstate(getPayUrl(), wxConfig, applyment_id, business_code);
    }

    /**
     * @Description 提交升级申请单接口
     * @Author wanglie
     * @Date 1:09 2019/4/9
     **/
    public Map<String, Object> submitupgrade(
            String cert_sn,
            String sub_mch_id,
            String organization_type,
            String business_license_copy,
            String business_license_number,
            String merchant_name,
            String company_address,
            String legal_person,
            String business_time,
            String business_licence_type,
            String merchant_shortname,
            String business_scene
    ) {
        return WeixinApplyUtils.submitupgrade(getPayUrl(), new UpdateSubmitReqData(wxConfig, cert_sn, sub_mch_id, organization_type, business_license_copy,
                business_license_number, merchant_name, company_address, legal_person, business_time, business_licence_type, merchant_shortname,
                wxConfig.getRate(), business_scene));
    }

    /**
     * @Description 查询升级申请单状态接口
     * @Author wanglie
     * @Date 0:49 2019/4/9
     **/
    public Map<String, Object> getupgradestate(String sub_mch_id) {
        return WeixinApplyUtils.getupgradestate(getPayUrl(), wxConfig, sub_mch_id);
    }
}
