package com.lorne.weixin.pay.model;

import com.lorne.weixin.pay.util.RandomStringGenerator;
import com.lorne.weixin.pay.util.Signature;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @ClassName: CertficatesReqData
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/3/25 23:08
 * @Version: V1.0.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CertficatesReqData extends MapXml {

    // https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=19_11

    private String mch_id;

    private String nonce_str;

    private String sign;

    private String sign_type = Signature.HMACSHA256;

    public CertficatesReqData(String key, String mch_id) {
        this.mch_id = mch_id;

        // 随机字符串，不长于32 位
        setNonce_str(RandomStringGenerator.getRandomStringByLength(32));

        // 根据API给的签名规则进行签名
        String sign = Signature.getSign(toMap(), key);

        setSign(sign);// 把签名数据设置到Sign这个属性中
    }
}
