package com.lorne.weixin.pay.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class CertificateEntity {

    // 平台证书序列号serial_no
    private String serialNo;

    // 证书启用时间
    private String effectiveTime;

    // 证书弃用时间
    private String expireTime;

    // 针对`algorithm`中描述的算法（目前为`AEAD_AES_256_GCM`），取得对应的参数`nonce`和`associated_data`。
    private String algorithm;

    // 使用`key`、`nonce`和`associated_data`，对数据密文`ciphertext`进行解密，得到平台证书的原文，
    private String nonce;

    private String associatedData;

    private String ciphertext;

    // 解码后的平台证书
    private String cert;
}
