package com.lorne.weixin.pay.model;

import com.lorne.weixin.pay.util.RandomStringGenerator;
import com.lorne.weixin.pay.util.Signature;

public class CheckBillReqData extends MapXml {

    private String appid = "";

    private String mch_id = "";

    private String sub_mch_id = "";

    /**
     * 随机字符串
     */
    private String nonce_str = "";

    /**
     * 签名
     */
    private String sign = "";

    /**
     * 对账单日期
     */
    private String bill_date = "";

    /**
     * 账单类型
     */
    private String bill_type = "";

    /**
     * 压缩账单 非必传参数，固定值：GZIP，返回格式为.gzip的压缩包账单。不传则默认为数据流形式。
     */
    private String tar_type = "";

    public CheckBillReqData(String appid, String mch_id, String sub_mch_id, String key, String bill_date, String bill_type) {
        this.appid = appid;
        this.mch_id = mch_id;
        this.sub_mch_id = sub_mch_id;
        this.bill_date = bill_date;
        this.bill_type = bill_type;

        setNonce_str(RandomStringGenerator.getRandomStringByLength(32));

        // 根据API给的签名规则进行签名
        String sign = Signature.getSign(toMap(), key);

        setSign(sign);// 把签名数据设置到Sign这个属性中
    }

    public CheckBillReqData(String appid, String mch_id, String sub_mch_id, String key, String bill_date, String bill_type, String tar_type) {
        this.appid = appid;
        this.mch_id = mch_id;
        this.sub_mch_id = sub_mch_id;
        this.bill_date = bill_date;
        this.bill_type = bill_type;
        this.tar_type = tar_type;

        setNonce_str(RandomStringGenerator.getRandomStringByLength(32));

        // 根据API给的签名规则进行签名
        String sign = Signature.getSign(toMap(), key);

        setSign(sign);// 把签名数据设置到Sign这个属性中
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getMch_id() {
        return mch_id;
    }

    public void setMch_id(String mch_id) {
        this.mch_id = mch_id;
    }

    public String getSub_mch_id() {
        return sub_mch_id;
    }

    public void setSub_mch_id(String sub_mch_id) {
        this.sub_mch_id = sub_mch_id;
    }

    public String getNonce_str() {
        return nonce_str;
    }

    public void setNonce_str(String nonce_str) {
        this.nonce_str = nonce_str;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getBill_date() {
        return bill_date;
    }

    public void setBill_date(String bill_date) {
        this.bill_date = bill_date;
    }

    public String getBill_type() {
        return bill_type;
    }

    public void setBill_type(String bill_type) {
        this.bill_type = bill_type;
    }

    public String getTar_type() {
        return tar_type;
    }

    public void setTar_type(String tar_type) {
        this.tar_type = tar_type;
    }
}
