package com.lorne.weixin.pay.model;

import com.lorne.weixin.pay.util.RandomStringGenerator;
import com.lorne.weixin.pay.util.Signature;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @ClassName: ApplyQueryReqData
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/4/9 0:51
 * @Version: V1.0.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GetSubmitReqData extends MapXml {

    // https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=19_3

    private String version = "1.0";

    private String mch_id;

    private String nonce_str;

    private String sign_type = Signature.HMACSHA256;

    private String sign;

    private String applyment_id;

    private String business_code;

    public GetSubmitReqData(WxConfig wxConfig, String applyment_id, String business_code) {
        this.mch_id = wxConfig.getMchId();
        // 随机字符串，不长于32 位
        setNonce_str(RandomStringGenerator.getRandomStringByLength(32));
        // 微信支付分配的申请单号。applyment_id、business_code两者不能同时为空。
        this.applyment_id = applyment_id;
        // 服务商自定义的商户唯一编号。当applyment_id已填写时，此字段无效。
        this.business_code = business_code;
        setSign(Signature.getSign(toMap(), wxConfig.getKey()));// 把签名数据设置到Sign这个属性中
    }
}
