package com.lorne.weixin.pay.model;

import com.lorne.weixin.pay.util.RandomStringGenerator;
import com.lorne.weixin.pay.util.Signature;
import lombok.Data;

/**
 * @ClassName: GetUpdateSubmitReqData
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/4/9 1:37
 * @Version: V1.0.0
 */
@Data
public class GetUpdateSubmitReqData extends MapXml {

    // https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=28_3&index=3

    private String version;

    private String mch_id;

    private String nonce_str;

    private String sign_type = Signature.HMACSHA256;

    private String sign;

    private String sub_mch_id;


    public GetUpdateSubmitReqData(WxConfig wxConfig, String sub_mch_id) {
        this.mch_id = wxConfig.getMchId();
        // 随机字符串，不长于32 位
        setNonce_str(RandomStringGenerator.getRandomStringByLength(32));

        // 根据API给的签名规则进行签名
        String sign = Signature.getSign(toMap(), wxConfig.getKey());

        setSign(sign);// 把签名数据设置到Sign这个属性中
        this.sub_mch_id = sub_mch_id;
    }
}
