package com.lorne.weixin.pay.model;

import com.lorne.weixin.pay.util.RandomStringGenerator;
import com.lorne.weixin.pay.util.Signature;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang.StringUtils;

/**
 * @ClassName: SubmitReqData
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/3/25 23:37
 * @Version: V1.0.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SubmitReqData extends MapXml {

    // https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=19_2

    private String version = "3.0";

    private String cert_sn;

    private String mch_id;

    private String nonce_str;

    private String sign_type = Signature.HMACSHA256;

    private String sign;

    private String business_code;

    private String id_card_copy;

    private String id_card_national;

    private String id_card_name;

    private String id_card_number;

    private String id_card_valid_time;

    private String account_name;

    private String account_bank;

    private String bank_address_code;

    private String bank_name;

    private String account_number;

    private String store_name;

    private String store_address_code;

    private String store_street;

    private String store_entrance_pic;

    private String indoor_pic;

    private String address_certification;

    private String merchant_shortname;

    private String service_phone;

    private String product_desc;

    private String rate;

    private String contact;

    private String contact_phone;

    private String store_longitude;

    private String store_latitude;

    private String business_addition_desc;

    private String business_addition_pics;

    private String contact_email;


    public SubmitReqData(String mch_id, String rate, String key, String cert_sn, String business_code, String id_card_copy, String id_card_national, String id_card_name,
                         String id_card_number, String id_card_valid_time, String account_name, String account_bank, String bank_address_code, String bank_name,
                         String account_number, String store_name, String store_address_code, String store_street, String store_entrance_pic,
                         String indoor_pic, String address_certification, String merchant_shortname, String service_phone, String product_desc,
                         String contact, String contact_phone, String contact_email) {
        this.cert_sn = cert_sn;
        this.mch_id = mch_id;
        setNonce_str(RandomStringGenerator.getRandomStringByLength(32));
        this.business_code = business_code;
        this.id_card_copy = id_card_copy;
        this.id_card_national = id_card_national;
        this.id_card_name = id_card_name;
        this.id_card_number = id_card_number;
        this.id_card_valid_time = id_card_valid_time;
        this.account_name = account_name;
        this.account_bank = account_bank;
        this.bank_address_code = bank_address_code;
        this.bank_name = bank_name;
        this.account_number = account_number;
        this.store_name = store_name;
        this.store_address_code = store_address_code;
        this.store_street = store_street;
        this.store_entrance_pic = store_entrance_pic;
        this.indoor_pic = indoor_pic;
        if (StringUtils.isNotBlank(address_certification))
            this.address_certification = address_certification;
        this.merchant_shortname = merchant_shortname;
        this.service_phone = service_phone;
        this.product_desc = product_desc;
        this.rate = rate;
        this.contact = contact;
        this.contact_phone = contact_phone;
        this.contact_email = contact_email;
        setSign(Signature.getSign(toMap(), key));
    }
}
