package com.lorne.weixin.pay.model;

import com.lorne.weixin.pay.util.RandomStringGenerator;
import com.lorne.weixin.pay.util.Signature;
import lombok.Data;

/**
 * @ClassName: UpdateSubmitReqData
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/4/9 1:18
 * @Version: V1.0.0
 */
@Data
public class UpdateSubmitReqData extends MapXml {

    // https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=28_2&index=2

    private String version = "1.0";
    private String mch_id;
    private String nonce_str;
    private String sign_type = Signature.HMACSHA256;
    private String sign;
    private String cert_sn;
    private String sub_mch_id;
    private String organization_type;
    private String business_license_copy;
    private String business_license_number;
    private String merchant_name;
    private String company_address;
    private String legal_person;
    private String business_time;
    private String business_licence_type;
    private String organization_copy;
    private String organization_number;
    private String organization_time;
    private String account_name;
    private String account_bank;
    private String bank_address_code;
    private String bank_name;
    private String merchant_shortname;
    private String business;
    private String qualifications;
    private String business_scene;
    private String business_addition_desc;
    private String business_addition_pics;
    private String mp_appid;
    private String mp_app_screen_shots;
    private String miniprogram_appid;
    private String miniprogram_screen_shots;
    private String app_appid;
    private String app_screen_shots;
    private String app_download_url;
    private String web_url;
    private String web_authoriation_letter;
    private String web_appid;

    public UpdateSubmitReqData(WxConfig wxConfig, String cert_sn, String sub_mch_id, String organization_type, String business_license_copy,
                               String business_license_number, String merchant_name, String company_address, String legal_person, String business_time,
                               String business_licence_type, String merchant_shortname, String business, String business_scene) {
        this.mch_id = wxConfig.getMchId();
        // 随机字符串，不长于32 位
        setNonce_str(RandomStringGenerator.getRandomStringByLength(32));
        // 根据API给的签名规则进行签名
        String sign = Signature.getSign(toMap(), wxConfig.getKey());

        setSign(sign);// 把签名数据设置到Sign这个属性中

        this.cert_sn = cert_sn;
        this.sub_mch_id = sub_mch_id;
        this.organization_type = organization_type;
        this.business_license_copy = business_license_copy;
        this.business_license_number = business_license_number;
        this.merchant_name = merchant_name;
        this.company_address = company_address;
        this.legal_person = legal_person;
        this.business_time = business_time;
        this.business_licence_type = business_licence_type;
        this.merchant_shortname = merchant_shortname;
        this.business = business;
        this.business_scene = business_scene;

    }
}
