package com.lorne.weixin.pay.model;

import com.lorne.weixin.pay.util.Signature;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;

/**
 * @ClassName: UploadReqData
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/3/25 23:59
 * @Version: V1.0.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UploadReqData extends MapXml {

    //  https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=19_9

    private String mch_id;

    private String media;

    private String media_hash;

    private String sign;

    private String sign_type = "HMAC-SHA256";

    public UploadReqData(String key, String mchId, File file) {
        this.mch_id = mchId;
        this.media_hash = md5HashCode(file);
        setSign(Signature.getSign(toMap(), key));// 把签名数据设置到Sign这个属性中
        this.media = file.getName();
    }

    /**
     * 对上次文件进行MD5获取其Hash值
     *
     * @param file
     * @return
     */
    public static String md5HashCode(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            MessageDigest MD5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            int length;
            while ((length = fis.read(buffer)) != -1) {
                MD5.update(buffer, 0, length);
            }
            return new String(Hex.encodeHex(MD5.digest()));
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        } finally {
            try {
                if (fis != null)
                    fis.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public MultipartEntityBuilder multipartEntityBuilder(File file) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.addTextBody("mch_id", mch_id, ContentType.MULTIPART_FORM_DATA);
        multipartEntityBuilder.addBinaryBody("media", file, ContentType.create("image/jpg"), this.getMedia());
        multipartEntityBuilder.addTextBody("media_hash", media_hash, ContentType.MULTIPART_FORM_DATA);
        multipartEntityBuilder.addTextBody("sign_type", sign_type, ContentType.MULTIPART_FORM_DATA);
        multipartEntityBuilder.addTextBody("sign", sign, ContentType.MULTIPART_FORM_DATA);
        return multipartEntityBuilder;
    }
}
