package com.lorne.weixin.pay.nutils;

import com.alibaba.fastjson.JSONObject;
import com.lorne.core.framework.utils.http.HttpUtils;
import com.lorne.weixin.pay.model.*;
import com.lorne.weixin.pay.util.HttpsRequest;
import com.lorne.weixin.pay.util.LogUtils;
import com.lorne.weixin.pay.util.XMLParser;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HTTP;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

import javax.net.ssl.SSLContext;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Map;

/**
 * @ClassName: WeixinResourceUtils
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/4/9 0:00
 * @Version: V1.0.0
 */
public class WeixinApplyUtils {

    private static final Logger LOGGER = LoggerFactory.getLogger(WeixinApplyUtils.class);

    // 微信支付申请相关接口
    // 10) 图片上传API
    public static String UPLOAD_MEDIA = "/secapi/mch/uploadmedia";
    // 11）获取平台证书
    public static String GET_CERTFICATES = "/risk/getcertficates";
    // 12）申请入驻
    public static String SUBMIT = "/applyment/micro/submit";
    // 13）查询申请状态
    public static String GET_SUBMIT_STATE = "/applyment/micro/getstate";
    // 14）提交升级申请单接口
    public static String SUBMIT_UPGRADE = "/applyment/micro/submitupgrade";
    // 15）查询升级申请单状态接口
    public static String GET_SUBMIT_UPGRADE_STATE = "/applyment/micro/getupgradestate";

    /**
     * @Description 微信商户传图片
     * @Author wanglie
     * @Date 1:46 2019/4/9
     **/
    public static Map<String, Object> upload(String url, WxConfig config, File file) {
        try {
            UploadReqData uploadReqData = new UploadReqData(config.getKey(), config.getMchId(), file);
            LogUtils.logResult("官方微信--上传图片请求参数：{}", JSONObject.toJSONString(uploadReqData));
            MultipartEntityBuilder multipartEntityBuilder = uploadReqData.multipartEntityBuilder(file);
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            File certFile = ResourceUtils.getFile("classpath:" + config.getCertLocalPath());
            FileInputStream instream = new FileInputStream(certFile);
            keyStore.load(instream, config.getMchId().toCharArray());// 这里写密码..默认是你的MCHID
            SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, config.getMchId().toCharArray()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
            HttpPost httpPost = new HttpPost(url + UPLOAD_MEDIA);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
            httpPost.setConfig(requestConfig);
            ////这里的Content-type要设置为"multipart/form-data"，否则返回“参数填写有误，请检查后重试”
            httpPost.addHeader(HTTP.CONTENT_TYPE, "multipart/form-data; charset=UTF-8");
            httpPost.addHeader(HTTP.USER_AGENT, "wxpay sdk java v1.0 " + config);
            httpPost.setEntity(multipartEntityBuilder.build());
            CloseableHttpResponse response = httpclient.execute(httpPost);
            String result = EntityUtils.toString(response.getEntity(), "UTF-8");
            LogUtils.logResult("官方微信--上传图片返回结果：{}", result);
            return XMLParser.getMapFromXML(result);
        } catch (Exception e) {
            LOGGER.error("官方微信--上传图片异常：{}", e);
            return null;
        }
    }

    /**
     * @Description 获取商户证书
     * @Author wanglie
     * @Date 23:24 2019/3/25
     **/
    public static Map<String, Object> getcertficates(String url, WxConfig config) {
        CertficatesReqData certficatesReqData = new CertficatesReqData(config.getKey(), config.getMchId());
        String postDataXML = certficatesReqData.toXml();
        LogUtils.logResult("请求获取商户平台证书", postDataXML);
        try {
            String res = HttpUtils.postXml(url + GET_CERTFICATES,
                    postDataXML);
            LogUtils.logResult("响应获取商户平台证书", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * @Description 申请入驻
     * @Author wanglie
     * @Date 1:07 2019/3/26
     **/
    public static Map<String, Object> submit(WxConfig wxConfig, String url, SubmitReqData submitReqData) {
        String postDataXML = submitReqData.toXml();
        LogUtils.logResult("申请入驻", postDataXML);
        try {
            HttpsRequest httpsRequest = new HttpsRequest(wxConfig);
            String res = httpsRequest.sendPost(url + SUBMIT,
                    postDataXML);
            LogUtils.logResult("响应申请入驻", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }


    /**
     * @Description 查询申请状态
     * @Author wanglie
     * @Date 0:58 2019/4/9
     **/
    public static Map<String, Object> getstate(String url, WxConfig wxConfig, String applyment_id, String business_code) {
        String postDataXML = new GetSubmitReqData(wxConfig, applyment_id, business_code).toXml();
        LogUtils.logResult("查询申请状态", postDataXML);
        try {
            HttpsRequest httpsRequest = new HttpsRequest(wxConfig);
            String res = httpsRequest.sendPost(url + GET_SUBMIT_STATE,
                    postDataXML);
            LogUtils.logResult("响应申请状态", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * @Description 提交升级申请单接口
     * @Author wanglie
     * @Date 1:32 2019/4/9
     **/
    public static Map<String, Object> submitupgrade(String url, UpdateSubmitReqData updateSubmitReqData) {
        String postDataXML = updateSubmitReqData.toXml();
        LogUtils.logResult("提交升级申请单", postDataXML);
        try {
            String res = HttpUtils.postXml(url + SUBMIT_UPGRADE,
                    postDataXML);
            LogUtils.logResult("响应升级申请单", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * @Description 查询升级申请单状态接口
     * @Author wanglie
     * @Date 1:43 2019/4/9
     **/
    public static Map<String, Object> getupgradestate(String url, WxConfig wxConfig, String sub_mch_id) {
        String postDataXML = new GetUpdateSubmitReqData(wxConfig, sub_mch_id).toXml();
        LogUtils.logResult("查询升级申请单状态", postDataXML);
        try {
            String res = HttpUtils.postXml(url + GET_SUBMIT_UPGRADE_STATE,
                    postDataXML);
            LogUtils.logResult("响应升级申请单状态", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
