package com.lorne.weixin.pay.nutils;

import com.alibaba.fastjson.JSONObject;
import com.lorne.core.framework.utils.http.HttpUtils;
import com.lorne.weixin.pay.model.*;
import com.lorne.weixin.pay.util.HttpsRequest;
import com.lorne.weixin.pay.util.LogUtils;
import com.lorne.weixin.pay.util.XMLParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WeixinPublicUtils {
    
    private static Logger logger = LoggerFactory.getLogger(WeixinPublicUtils.class);

    // 1) 获取openid
    public final static String JSCODE_SESSION_API = "/sns/jscode2session";

    // 2) 获取openid
    public final static String PAY_ACCESS_TOKEN = "/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";

    // 3) 发送模板消息
    public final static String SEND_MSG = "/cgi-bin/message/wxopen/template/send?access_token=%s";

    public static Map<String, Object> jscode2session(String url, WxConfig config, String jsCode) {
        url = url + JSCODE_SESSION_API + "?appid=" + config.getAppId() + "&secret=" + config.getAppSecret() + "&js_code=" + jsCode + "&grant_type=authorization_code";
        Map<String, Object> map = null;
        String res = HttpUtils.get(url);
        LogUtils.logResult("获取sessionKey与opendId订单", res);
        try {
            map = JSONObject.parseObject(res);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return map;
    }

    public static Map<String, Object> getAccessToken(String url, WxConfig config) {
        url = String.format(url + PAY_ACCESS_TOKEN, config.getAppId(), config.getAppSecret());
        Map<String, Object> map = null;
        String res = HttpUtils.get(url);
        LogUtils.logResult("获取ACCESS_TOKEN", res);
        try {
            map = JSONObject.parseObject(res);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return map;
    }

    public static Map<String, Object> pushMsg(String url, String accessToken, String touser, String templateId, String formId, List<TemplateMsg> value) {
        url = String.format(url + SEND_MSG, accessToken);

        Map<String, Object> data = new HashMap<>();
        data.put("touser", touser);
        data.put("template_id", templateId);
        data.put("form_id", formId);
        Map<String, Object> msgs = new HashMap<>();
        for (int i = 0; i < value.size(); i++) {
            TemplateMsg msg = value.get(i);
            msgs.put("keyword" + (i + 1), msg);
        }
        data.put("data", msgs);
        String json = new JSONObject(data).toJSONString();
        System.out.println(json);
        String res = HttpUtils.postJson(url, json);
        LogUtils.logResult("发送模板消息", res);
        Map<String, Object> map = null;
        try {
            map = JSONObject.parseObject(res);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return map;
    }
}
