package com.lorne.weixin.pay.util;

import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.util.Base64;

/**
 * @ClassName: AesGcmExample2
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/4/11 2:15
 * @Version: V1.0.0
 */
public class AesGcmExample2 {

    private static final String ALGORITHM = "AES/GCM/NoPadding";
    private static final int TAG_LENGTH_BIT = 128;
    private static final int NONCE_LENGTH_BYTE = 12;
    //    private static final String AES_KEY = "PAY9926wxAPIfromNGFFatJHSCALEcom"; // APIv3密钥
    private static final String TRANSFORMATION_PKCS1Padding = "RSA/ECB/PKCS1Padding";

    /**
     * @Description APIv3密钥 解密
     * @Author wanglie
     * @Date 2:22 2019/4/11
     **/
    public static String aesgcmDecrypt(String v3key, String associatedData, String nonce, String cipherText) throws Exception {
        final Cipher cipher = Cipher.getInstance(ALGORITHM, "SunJCE");
        SecretKeySpec key = new SecretKeySpec(v3key.getBytes(), "AES");
        GCMParameterSpec spec = new GCMParameterSpec(TAG_LENGTH_BIT, nonce.getBytes());
        cipher.init(Cipher.DECRYPT_MODE, key, spec);
        cipher.updateAAD(associatedData.getBytes());
        return new String(cipher.doFinal(Base64.getDecoder().decode(cipherText)));
    }
//
//    public static void main(String[] args) {
//        final String associatedData = "certificate"; // encrypt_certificate.associated_data
//        final String nonce = "a4fb18045148"; // encrypt_certificate.nonce
//        final String cipherText = "l6zMqt23nYkIU/P5DgwwRj+qeh74qVbqDWQZGmfy50LnWZzTsuIvgOB52VqL0lDuf2+dJXMH8jJ+RotEX1o7f1133uvoEjf1ey6ch/lhYxYLXws0hYnlORwhvZXxNuOOiDqBMZkSvZVyHDZKguMLU3S4HZYXJTPXI3TceuM7bq2lqb0HY8RyVlJc8EmJBs71qPqfkP/F3cps9J/r2/7quvwbMJbBKcBUUnEc92x0jsvU+Md7bVfByjpkLNegfpRvj9VqQCwTye8hcys44d55ZcH2V9/JP6wUKyI5oxA5F/meC72XuEozoP3F63IsiMvpG1O/rG77JfMck8i7TeFUOAqzfRNeSo+obVUdhNMGpt+0ZZuVxB34NWRkeUlpWR5lPcY1kjuoiF9kjbW4s2WRzP3QR9yZ6A79/2adcafcDNTFMbZ+5FPA5fzJTe9i+DRIe0HxP1/e/ZU2QYI5eOOJruQe1EVWNkK8SU/3vrWUInIS1nTcOfVAHR2cgCIjyhzGiN/Fq1jhGc1kcEIHY2Yrw/UEN1J9F8XQF8ZippHjTXUmE/zyeNi8qYPCD8giPErhqrIxOY6keRP9I5cW8FhXFXytDzbvfYO4sz1X7hSpp+LLj22d8KtHUN71FLI0RkpyTQ8/czTYWZvH96pj4luPFvN+fxn3GTVtgjTW4SPmU5TWCKmK0H+2jTvKj41waHdEO9b/gCLnf1j9BwNox4/YMRGSgwLzuuT03hpfkowBteWZOO5pTu6T6kpQhrv/WD36lQLZrdhAHht1mVTC4rbAiZMNWC2jxFI2Fghew2BpgFsW8gRPQewjYMWpxuObLhO/pYzYIXoAK3T3rpsW7sCnQOUoybuPJNyxkRoa2TQL0D/7Elvg/KVwTPU8IxL96L5TNLcR3eDDA4HWQ8vpRh5jQZCMPVz+7cxKZawT0719NZLzdGsKQmpEOOCK8t61V/K6Ha97i/Q8KO7xcQr2kq6JV8c7rhUhWrLaVpNYao96fYeYq0O1IJjyyzsw7jYd1DySRlAvlXwpaoQTYvhOF3y//RALGC/NR8DJotq0pt3N5O+q5LJ03ZdP3C0+zyYX4EWEibM0KA/kKqlVOed5AKBC8s8SLwaV0vtOkuUxSY4ruCnO0e4c6wNn+cyggEkUS3vNVqGuSxLEeNjtKPAhitFNUf7opqL92WofKn4WyRL5Wemm6Ebbba6+F5RMuLKJ7eN4i82m5P4zB+5fuVX8BHZ3SbJS3za9f734MNATwFXeVbMit6fj0+NGQ4aA4q1w3GuREC9lVzzParl/1Nzn5owpVidybVVgQqSWv5awYFt6TfAJYEW7SpbWTqVEQZMKWvF9feFsz1PY8ogKaNMdCs69q11ZT7HGqAbPHYtaWqq8u+74kMIpAZyGHrkdsR6D4UbRzJ8Ey2VlW8pQWWlPlreJOX8U+yOm041tHaZiJLWYdrU8Bk00M8/HFtdj+hOdcVKuCF0vzdhVYx8BMP0BC+DKMuBbLEHPageUy84Ye7AceIQWiQYvTJZC1FekyFIS4qPJB/qtSoxZBlZ88z6oDWZHqpB+AwBx0CnENA6dhze8LeBIZet8CFHDBcXxr1V89uTE1CXrYgE+8CYbjgeb6hWXRASdxn3ZWoaaFHHGCNeB/eWzwVXdkiqFn7Sr8OnnqyWr3j4Wzyq2s/TI5vz8YjwU/gVdKW4zQ1ZdLNYZ9LNExAvldqWwXB1rF0KwadzYyP0WGuBiP2r8ft7miVDVTp7aHTuVFF7Ari7t1mpSsW8Tv/HdGMrZYkRf74/GP0+vJoIJxTD9Cfv9kIXJOyY8hfstiLp9OcgwLAaTrlxvQaxZ9CH6x+h+/3pUPGvDYucsaRQTCdx0NwTBTOjw9ZIG8jH2cJLZR51kUA=="; // encrypt_certificate.ciphertext
//        try {
//            String wechatpayCert = aesgcmDecrypt("PAY9926wxAPIfromNGFFatJHSCALEcom", associatedData, nonce, cipherText);
//            System.out.println(wechatpayCert);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//    }
}
