package com.lorne.weixin.pay.wxUtil;

import com.lorne.weixin.pay.constant.WXConstant;
import com.lorne.weixin.pay.model.WxConfig;


import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.SortedMap;
import java.util.TreeMap;

public class AnnotationUtil {
    /**
     * object转map
     * @param
     * @return
     */
    public static SortedMap<String, String> parseObjectToMap(Object obj,WxConfig wxConfig){
        ArrayList<Field> fileds = new ArrayList<>();
        Class<?> objClass = obj.getClass();
        fileds.addAll(Arrays.asList(objClass.getDeclaredFields()));
        if(objClass.getSuperclass()!=null){
            fileds.addAll(Arrays.asList(objClass.getSuperclass().getDeclaredFields()));
        }
        SortedMap<String,String> map = new TreeMap<>();
        fileds.forEach(filed->{
            filed.setAccessible(true);
            Annotation annotations = filed.getAnnotation(WXPayParam.class);
            String k = ((WXPayParam) annotations).value();
            try {
                String v =  String.valueOf(filed.get(obj));
                if (null != v && !"".equals(v) && !"null".equals(v)) {
                    map.put(k,v);
                }
            } catch (IllegalAccessException e) {
                return;
            }
        });
        if(WXConstant.SIGNTTYPE.equals(map.get("sign_type"))){
            map.put("sign",WXPayUtil.generateSignature(map,wxConfig.getKey(),WXConstant.HMACSHA256TYPE));
        }else{
            map.put("sign",WXPayUtil.generateSignature(map,wxConfig.getKey(),WXConstant.MD5TYPE));
        }
        return map;
    }
}
