package com.lorne.weixin.pay.wxUtil;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMACSHAUtil {
    /**
     * 生成 HMACSHA256
     * @param data 待处理数据
     * @param key 密钥
     * @return 加密结果
     * @throws Exception
     */
    public static String getHMACSHA256(String data, String key){
        Mac sha256_HMAC;
        byte[] array = null ;
        try {
            sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            array = sha256_HMAC.doFinal(data.getBytes("UTF-8"));
        } catch (Exception e) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString((item & 0xFF) | 0x100).substring(1, 3));
        }
        return sb.toString().toUpperCase();
    }
}
