package com.lorne.weixin.pay.wxUtil;

import com.lorne.weixin.pay.model.WxConfig;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.ssl.SSLContext;
import java.io.*;
import java.net.URL;
import java.security.KeyStore;
import java.util.SortedMap;

public class WXPayHttpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(WXPayHttpUtil.class);

    private final static String UTFCHARSET = "UTF-8";
    private final static String XMLCONTENT = "text/xml;charset=utf-8";
    private final static String FORMCONTENT = "multipart/form-data;charset=utf-8";

    /**
     * 需证书上传form表单形式接口
     *
     * @param url      接口地址
     * @param mcdId    商户号即密码
     * @param certPath 证书文件位置
     * @param builder  表单参数
     * @return
     */
    public static String WXHttpPostFormWithCert(String url, String mcdId, String certPath, MultipartEntityBuilder builder) {
        HttpPost uploadFile = new HttpPost(url);
        SSLConnectionSocketFactory sslsf = null;
        StringBuilder stringBuilder = new StringBuilder();
        //读取本机存放的PKCS12证书文件
        ClassLoader classLoader = WXPayHttpUtil.class.getClassLoader();
        URL resource = classLoader.getResource(certPath);
        try (FileInputStream pkcfile = new FileInputStream(new File(resource.getPath()));
        ) {
            //指定读取证书格式为PKCS12
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            //"100000"为密码即商户号
            keyStore.load(pkcfile, mcdId.toCharArray());
            SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, mcdId.toCharArray()).build();
            //指定TLS版本
            sslsf = new SSLConnectionSocketFactory(sslcontext);
        } catch (Exception e) {
            LOGGER.debug(e.getMessage());
            return "";
        }
        HttpEntity multipart = builder.build();
        uploadFile.setEntity(multipart);
        uploadFile.setHeader("Content-Type", FORMCONTENT);
        try (CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory(sslsf).build();
             CloseableHttpResponse response = client.execute(uploadFile);) {
            if (response != null && response.getEntity() != null) {
                HttpEntity entity = response.getEntity();
                try (
                        InputStream in = entity.getContent();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"))) {
                    reader.lines().forEach(line -> {
                        stringBuilder.append(line);
                    });
                }
            }
        } catch (IOException e) {
            LOGGER.debug(e.getMessage());
            return "";
        }


        return stringBuilder.toString();
    }

    /**
     * 不需证书上传xml形式接口
     *
     * @param url       接口地址
     * @param reqDataTo 请求参数
     * @return
     */
    public static String WXHttpPostXMLWithoutCert(String url, SortedMap<String, String> reqDataTo) {
        HttpPost httpPost = new HttpPost(url);
        StringEntity postEntity = new StringEntity(WXPayXmlUtil.parseMapToXML(reqDataTo), UTFCHARSET);
        httpPost.setHeader("Content-Type", XMLCONTENT);
        httpPost.setEntity(postEntity);
        StringBuilder stringBuilder = new StringBuilder();
        try (CloseableHttpClient client = HttpClients.createDefault();
             CloseableHttpResponse response = client.execute(httpPost);) {
            if (response != null && response.getEntity() != null) {
                HttpEntity entity = response.getEntity();
                try (
                        InputStream in = entity.getContent();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"))) {
                    reader.lines().forEach(line -> {
                        stringBuilder.append(line);
                    });
                    ;
                }
            }
        } catch (IOException e) {
            LOGGER.debug(e.getMessage());
            return "";
        }
        return stringBuilder.toString();
    }

    /**
     * 需证书上传xml形式接口
     *
     * @param url      接口地址
     * @param reqData  参数
     * @param certPath 证书文件位置
     * @return
     */
    public static String WXHttpPostXMLWithCert(String url, SortedMap<String, String> reqData, String certPath) {
        HttpPost queryState = new HttpPost(url);
        SSLConnectionSocketFactory sslsf = null;
        //读取本机存放的PKCS12证书文件
//        ClassLoader classLoader = ConfigTool.class.getClassLoader();
        String currentPath = Thread.currentThread().getContextClassLoader().getResource(certPath).getPath();
        ClassLoader classLoader = WxConfig.class.getClassLoader();
        URL resource = classLoader.getResource(certPath);
        try (FileInputStream pkcfile = new FileInputStream(new File(resource.getPath()))
        ) {
            //指定读取证书格式为PKCS12
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            //"100000"为密码即商户号
            keyStore.load(pkcfile, reqData.get("mch_id").toCharArray());
            SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(
                    keyStore, reqData.get("mch_id").toCharArray()).build();
            sslsf = new SSLConnectionSocketFactory(sslcontext,
                    new String[]{"TLSv1"},
                    null,
                    new DefaultHostnameVerifier());
        } catch (Exception e) {
            LOGGER.debug(e.getMessage());
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringEntity postEntity = new StringEntity(WXPayXmlUtil.parseMapToXML(reqData), "UTF-8");
        queryState.setEntity(postEntity);
        queryState.setHeader("Content-Type", XMLCONTENT);
        try (CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory(sslsf).build();
             CloseableHttpResponse response = client.execute(queryState);) {
            if (response != null && response.getEntity() != null) {
                HttpEntity entity = response.getEntity();
                try (
                        InputStream in = entity.getContent();
                        BufferedReader reader = new BufferedReader(
                                new InputStreamReader(in, "UTF-8"))) {
                    reader.lines().forEach(line -> {
                        stringBuilder.append(line);
                    });
                }
            }
        } catch (IOException e) {
            LOGGER.debug(e.getMessage());
            return "";
        }
        return stringBuilder.toString();
    }
}
