package com.lorne.weixin.pay.wxUtil;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.Set;

public class WXPayUtil {
    private static final String ALGORITHM = "AES/GCM/NoPadding";
    private static final int TAG_LENGTH_BIT = 128;
    private static final String AES_KEY = "9bbbd2223e5240bb2252d05222210c27"; // APIv3密钥

    /**
     * @param aad
     * @param iv
     * @param cipherText
     * @return
     * @throws Exception
     */
    private static String aesgcmDecrypt(String aad, String iv, String cipherText) {
        try {
            final Cipher cipher = Cipher.getInstance(ALGORITHM, "SunJCE");
            SecretKeySpec key = new SecretKeySpec(AES_KEY.getBytes(), "AES");
            GCMParameterSpec spec = new GCMParameterSpec(TAG_LENGTH_BIT, iv.getBytes());
            cipher.init(Cipher.DECRYPT_MODE, key, spec);
            cipher.updateAAD(aad.getBytes());
            return new String(cipher.doFinal(Base64.getDecoder().decode(cipherText)));
        } catch (Exception e) {
            return "fail";
        }
    }

    public static String getWXCert(JSONArray data) {
        //敏感信息证书生成所需参数
        String encryptCertificate = JSONObject.parseObject(
                JSONObject.toJSONString(data.get(0))).getString("encrypt_certificate");
        String nonce = JSONObject.parseObject(
                encryptCertificate).getString("nonce");
        String associatedData = JSONObject.parseObject(
                encryptCertificate).getString("associated_data");
        //要被解密的证书字符串
        String cipherText = JSONObject.parseObject(
                encryptCertificate).getString("ciphertext");
        String wechatpayCert = "";
        try {
            wechatpayCert = aesgcmDecrypt(associatedData, nonce, cipherText);
        } catch (Exception e) {
            return wechatpayCert;
        }
        return wechatpayCert;
    }

    /**
     * 生成签名. 注意，若含有sign_type字段，必须和signType参数保持一致。
     *
     * @param data     待签名数据
     * @param key      API密钥
     * @param signType 签名方式
     * @return 签名
     */
    public static String generateSignature(final Map<String, String> data, String key, String signType) {
        Set<String> keySet = data.keySet();
        String[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (String k : keyArray) {
            if (k.equals("sign")) {
                continue;
            }
            if (data.get(k).trim().length() > 0) // 参数值为空，则不参与签名
                sb.append(k).append("=").append(data.get(k).trim()).append("&");
        }
        sb.append("key=").append(key);
        if ("MD5".equals(signType)) {
            return MD5.getMD5(sb.toString()).toUpperCase();
        } else if ("HMACSHA256".equals(signType)) {
            return HMACSHAUtil.getHMACSHA256(sb.toString(), key);
        }
        return signType;
    }

    //获取指定位数的随机字符串(包含小写字母、大写字母、数字,0<length)
    public static String getRandomString(int length) {
        //随机字符串的随机字符库
        String KeyString = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuffer sb = new StringBuffer();
        int len = KeyString.length();
        for (int i = 0; i < length; i++) {
            sb.append(KeyString.charAt((int) Math.round(Math.random() * (len - 1))));
        }
        return sb.toString();
    }
}